/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.cef3.CEF3Browser;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Event;

final class KeyboardHandler
extends CefKeyboardHandlerAdapter
implements FocusListener {
    private final CEF3Browser browser;
    private Stack<Integer> charCodes = new Stack();
    private Map<Integer, Integer> charMaps = new HashMap<Integer, Integer>();

    public KeyboardHandler(CEF3Browser browser) {
        this.charMaps.put(16, 131072);
        this.charMaps.put(17, 262144);
        this.charMaps.put(18, 65536);
        this.browser = browser;
        if (this.browser != null) {
            this.browser.addFocusListener(this);
        }
    }

    public boolean OnKeyEvent(CefBrowser cefBrowser, int type, int code, int modifiers, boolean isSystemKey, boolean isAfterJavaScript) {
        if (isAfterJavaScript) {
            return false;
        }
        if (this.charMaps.get(code) != null) {
            System.out.println("type:" + type);
            if (type == 0) {
                this.charCodes.add(this.charMaps.get(code));
            } else if (type == 2) {
                this.charCodes.remove(this.charMaps.get(code));
            }
            return true;
        }
        Event event = new Event();
        event.widget = this.browser;
        event.character = '\u0000';
        event.keyCode = code;
        while (!this.charCodes.isEmpty()) {
            event.stateMask |= this.charCodes.pop().intValue();
        }
        switch (type) {
            case 1: {
                System.out.println("KEYEVENT_KEYDOWN " + code + " " + modifiers + " " + isSystemKey);
                break;
            }
            case 2: {
                System.out.println("KEYEVENT_KEYUP " + code + " " + modifiers + " " + isSystemKey);
                break;
            }
            case 3: {
                System.out.println("KEYEVENT_CHAR " + code + " " + modifiers + " " + isSystemKey);
                break;
            }
            case 0: {
                System.out.println("KEYEVENT_RAWKEYDOWN " + code + " " + modifiers + " " + isSystemKey);
            }
        }
        this.browser.notifyEventListeners(1, event);
        return !event.doit;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.charCodes.clear();
    }
}

