/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.pandora.core.launcher.IStreamJSonListener;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.StringUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class StreamJsonUtil {
    public static Map<IProject, Map<String, Map<String, Set<String>>>> streamJsonMap = new ConcurrentHashMap<IProject, Map<String, Map<String, Set<String>>>>();
    public static HashMap<IProject, HashSet<String>> idleMap = new HashMap();
    public static Map<IProject, Map<String, String>> filiationJsonMap = new ConcurrentHashMap<IProject, Map<String, String>>();
    public static final String IDLE_KEY = "idle";
    public static final String REFER_KEY = "refer";
    public static final String RESOURCES_KEY = "resources";
    public static final String PRIORITY_KEY = "priority";
    public static final String DEPENDENCIES_KEY = "dependencies";
    public static final String PAGES_KEY = "pages";
    public static final String UNPACKAGE_KEY = "unpackage";
    public static final String LIMIT_PAGE_CONTENT_TYPE = "com.aptana.contenttype.html";
    private static IStreamJSonListener streamJSonListener;
    public static boolean isStreamJson;

    static {
        isStreamJson = false;
    }

    public static void setListener(IStreamJSonListener listener) {
        if (listener != null) {
            streamJSonListener = listener;
        }
    }

    public static IStreamJSonListener getListener() {
        return streamJSonListener;
    }

    public static void addResourceStreamJsonList(IProject project, String urlKey, String url) {
        StreamJsonUtil.addStreamJsonList(project, RESOURCES_KEY, urlKey, url);
    }

    public static void addReferStreamJsonList(IProject project, String urlKey, String url) {
        StreamJsonUtil.addStreamJsonList(project, REFER_KEY, urlKey, url);
    }

    public static void addFiliationStreamJsonList(IProject project, String urlKey, String url) {
        String filiation;
        Map<String, String> projectFiliationMap;
        IFile keyFile;
        IFile file;
        if (project == null || StringUtil.isBlank(url) || StringUtil.isBlank(urlKey)) {
            return;
        }
        int uindex = url.indexOf("?");
        if (uindex > -1) {
            url = url.substring(0, uindex);
        }
        if ((uindex = urlKey.indexOf("?")) > -1) {
            urlKey = urlKey.substring(0, uindex);
        }
        if (!(file = project.getFile(url)).exists()) {
            try {
                url = URLDecoder.decode(url, "UTF-8");
                file = project.getFile(url);
                if (!file.exists()) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(keyFile = project.getFile(urlKey)).exists()) {
            try {
                urlKey = URLDecoder.decode(urlKey, "UTF-8");
                keyFile = project.getFile(urlKey);
                if (!keyFile.exists()) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((projectFiliationMap = filiationJsonMap.get(project)) == null) {
            projectFiliationMap = new HashMap<String, String>();
        }
        if (StringUtil.isNotBlank(filiation = projectFiliationMap.get(urlKey))) {
            StreamJsonUtil.addReferStreamJsonList(project, urlKey, url);
        } else {
            projectFiliationMap.put(urlKey, url);
            filiationJsonMap.put(project, projectFiliationMap);
            StreamJsonUtil.addResourceStreamJsonList(project, urlKey, url);
        }
    }

    public static void clearFiliationJsonMap() {
        filiationJsonMap.clear();
    }

    private static void addStreamJsonList(IProject project, String keyType, String urlKey, String url) {
        Set<String> urlSet;
        Map<String, Set<String>> resouceMap;
        Map<String, Map<String, Set<String>>> projectMap;
        IFile keyFile;
        IFile file;
        if (project == null || StringUtil.isBlank(url) || StringUtil.isBlank(urlKey)) {
            return;
        }
        int uindex = url.indexOf("?");
        if (uindex > -1) {
            url = url.substring(0, uindex);
        }
        if ((uindex = urlKey.indexOf("?")) > -1) {
            urlKey = urlKey.substring(0, uindex);
        }
        if (!(file = project.getFile(url)).exists()) {
            try {
                url = URLDecoder.decode(url, "UTF-8");
                file = project.getFile(url);
                if (!file.exists()) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(keyFile = project.getFile(urlKey)).exists()) {
            try {
                urlKey = URLDecoder.decode(urlKey, "UTF-8");
                keyFile = project.getFile(urlKey);
                if (!keyFile.exists()) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((projectMap = streamJsonMap.get(project)) == null) {
            projectMap = new HashMap<String, Map<String, Set<String>>>();
            streamJsonMap.put(project, projectMap);
        }
        if ((resouceMap = projectMap.get(urlKey)) == null) {
            resouceMap = new HashMap<String, Set<String>>();
            projectMap.put(urlKey, resouceMap);
        }
        if ((urlSet = resouceMap.get(keyType)) == null) {
            urlSet = new HashSet<String>();
        }
        urlSet.add(url);
        resouceMap.put(keyType, urlSet);
    }

    public static void addIdleList(IProject project, String url) {
        if (project == null || StringUtil.isBlank(url)) {
            return;
        }
        IFile file = project.getFile(url);
        if (!file.exists()) {
            return;
        }
        HashSet<String> projectIdleSet = idleMap.get(project);
        if (projectIdleSet == null) {
            projectIdleSet = new HashSet();
        }
        projectIdleSet.add(url);
        idleMap.put(project, projectIdleSet);
    }

    public static void unionDepens(Map newMaps, Map oldMaps) {
        if (newMaps.containsKey(PAGES_KEY)) {
            Map newPagesMap = (Map)newMaps.get(PAGES_KEY);
            if (oldMaps.containsKey(PAGES_KEY)) {
                Map oldPagesMap = (Map)oldMaps.get(PAGES_KEY);
                for (Object key : newPagesMap.keySet()) {
                    if (oldPagesMap.containsKey(key)) {
                        ArrayList oldRefers;
                        Map oldPageMap = (Map)oldPagesMap.get(key);
                        Map newPageMap = (Map)newPagesMap.get(key);
                        Collection newResources = (Collection)newPageMap.get(RESOURCES_KEY);
                        Collection newRefers = (Collection)newPageMap.get(REFER_KEY);
                        ArrayList oldResources = (ArrayList)oldPageMap.get(RESOURCES_KEY);
                        if (oldResources == null) {
                            oldResources = new ArrayList();
                            oldPageMap.put(RESOURCES_KEY, oldResources);
                        }
                        if ((oldRefers = (ArrayList)oldPageMap.get(REFER_KEY)) == null) {
                            oldRefers = new ArrayList();
                            oldPageMap.put(REFER_KEY, oldRefers);
                        }
                        if (CollectionsUtil.isNotEmpty(newResources)) {
                            for (Object res : newResources) {
                                if (oldResources.contains(res) || oldRefers.contains(res)) continue;
                                oldResources.add(res);
                            }
                        }
                        if (!CollectionsUtil.isNotEmpty(newRefers)) continue;
                        for (Object ref : newRefers) {
                            if (oldResources.contains(ref) || oldRefers.contains(ref)) continue;
                            oldRefers.add(ref);
                        }
                        continue;
                    }
                    oldPagesMap.put(key, newPagesMap.get(key));
                }
            } else {
                oldMaps.put(PAGES_KEY, newPagesMap);
            }
        }
    }

    public static synchronized void syncStreamJSon() {
        ConcurrentHashMap<IProject, Map<String, Map<String, Set<String>>>> map = new ConcurrentHashMap<IProject, Map<String, Map<String, Set<String>>>>();
        map.putAll(streamJsonMap);
        streamJsonMap.clear();
        StreamJsonUtil.syncStreamJSon(map);
    }

    public static synchronized void syncStreamJSon(Map<IProject, Map<String, Map<String, Set<String>>>> map) {
        if (StreamJsonUtil.getListener() != null) {
            StreamJsonUtil.getListener().syncStreamJSon(map);
        }
    }

    public static Gson createGson() {
        GsonBuilder gsb = new GsonBuilder();
        gsb.registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

            public JsonElement serialize(Double arg0, Type arg1, JsonSerializationContext arg2) {
                JsonPrimitive jpt = new JsonPrimitive((Number)arg0.intValue());
                return jpt;
            }
        });
        Gson gs = gsb.setPrettyPrinting().create();
        return gs;
    }

    public static String toJson(Gson gs, Object dependObj) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = StreamJsonUtil.newJsonWriter(Streams.writerForAppendable((Appendable)writer));
        gs.toJson(dependObj, dependObj.getClass(), jsonWriter);
        return writer.toString();
    }

    private static JsonWriter newJsonWriter(Writer writer) {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setIndent("\t");
        jsonWriter.setSerializeNulls(false);
        return jsonWriter;
    }

    public static String getContents(IFile file) {
        block7: {
            block6: {
                try {
                    if (file != null) break block6;
                    return "";
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return "";
                }
            }
            try {
                file.refreshLocal(0, null);
            }
            catch (Throwable throwable) {}
            if (file.exists()) break block7;
            return "";
        }
        return IOUtil.read(file.getContents(), file.getCharset(true));
    }

    public static Map createPage() {
        LinkedHashMap<String, Integer> page = new LinkedHashMap<String, Integer>();
        page.put(PRIORITY_KEY, 0);
        return page;
    }

    public static boolean isPageContentType(IFile file) {
        if (file == null) {
            return false;
        }
        IContentTypeManager mgr = Platform.getContentTypeManager();
        IContentType type = mgr.findContentTypeFor(file.getName());
        return type != null && LIMIT_PAGE_CONTENT_TYPE.equals(type.getId());
    }

    public static IDocument createDocument(String content) {
        Document document = new Document(content);
        document.addPositionCategory(DEPENDENCIES_KEY);
        return document;
    }
}

