/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.StringUtil;
import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Device;

public class QRCodeUtils {
    public static final int DEFAULT_VERSION = 7;
    public static final int DEFAULT_DOTSIZE = 3;
    public static final int DEFAULT_BORDERSIZE = 2;

    public static org.eclipse.swt.graphics.Image createQRCodeByUrl(String url) {
        return QRCodeUtils.createQRCodeByUrl(url, Color.BLACK, Color.WHITE);
    }

    public static org.eclipse.swt.graphics.Image createQRCodeByUrl(String url, Color forground, Color background) {
        return QRCodeUtils.createQRCodeByUrl(url, 7, 3, 2, forground, background, null, 0);
    }

    @Deprecated
    public static org.eclipse.swt.graphics.Image createQRCodeByUrl(Device device, String url, Plugin plugin, int width, int height, int dotSize) {
        return QRCodeUtils.createQRCodeByUrl(url, 7, dotSize, 2, Color.BLACK, Color.WHITE, null, 0);
    }

    public static org.eclipse.swt.graphics.Image createQRCodeByUrl(String url, int version, int dotSize, int borderSize, Color forground, Color background, File logo, int forceWidthAndHeight) {
        try {
            BufferedImage bufImg = QRCodeUtils.encoderQRCode(url, version, dotSize, borderSize, forground, background, logo, forceWidthAndHeight);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufImg, "png", out);
            return new org.eclipse.swt.graphics.Image(null, (InputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
            return null;
        }
    }

    public static File createQRCodeFileByUrl(String url, Plugin plugin) {
        return QRCodeUtils.createQRCodeFileByUrl(url, plugin, 7, 3, 2, Color.BLACK, Color.WHITE, null, 0);
    }

    public static File createQRCodeFileByUrl(String url, Plugin plugin, int version, int dotSize, int borderSize, Color forground, Color background, File logo, int forceWidthAndHeight) {
        if (StringUtil.isBlank(url)) {
            return null;
        }
        File file = plugin.getBundle().getDataFile("qrcode.png");
        try {
            BufferedImage bufImg = QRCodeUtils.encoderQRCode(url, version, dotSize, borderSize, forground, background, logo, forceWidthAndHeight);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)bufImg, "png", file);
            return file;
        }
        catch (Exception e) {
            HBLog.logError(plugin, e);
            return null;
        }
    }

    public static BufferedImage encoderQRCode(String content, int version, int dotSize, int borderSize, Color forground, Color background, File logo, int forceWidthAndHeight) {
        Image bufImg;
        block23: {
            Graphics gs;
            block22: {
                bufImg = null;
                gs = null;
                try {
                    try {
                        Qrcode qrcodeHandler = new Qrcode();
                        qrcodeHandler.setQrcodeErrorCorrect('Q');
                        qrcodeHandler.setQrcodeEncodeMode('B');
                        qrcodeHandler.setQrcodeVersion(version);
                        byte[] contentBytes = content.toString().getBytes("utf-8");
                        int imgSize = QRCodeUtils.getQRSize(version, dotSize, borderSize);
                        bufImg = new BufferedImage(imgSize, imgSize, 2);
                        gs = ((BufferedImage)bufImg).createGraphics();
                        ((Graphics2D)gs).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        ((Graphics2D)gs).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        ((Graphics2D)gs).setBackground(background);
                        gs.clearRect(0, 0, imgSize, imgSize);
                        gs.setColor(forground);
                        if (contentBytes.length > 0 && contentBytes.length < 800) {
                            boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                            int i = 0;
                            while (i < codeOut.length) {
                                int j = 0;
                                while (j < codeOut.length) {
                                    if (codeOut[j][i]) {
                                        gs.fillRect(j * dotSize + borderSize, i * dotSize + borderSize, dotSize, dotSize);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            if (forceWidthAndHeight > 0) {
                                gs.dispose();
                                Image image = bufImg.getScaledInstance(forceWidthAndHeight, forceWidthAndHeight, 1);
                                bufImg.flush();
                                bufImg = new BufferedImage(forceWidthAndHeight, forceWidthAndHeight, 2);
                                gs = ((BufferedImage)bufImg).createGraphics();
                                ((Graphics2D)gs).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                ((Graphics2D)gs).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                                gs.drawImage(image, 0, 0, null);
                            }
                            if (logo != null && logo.exists() && logo.isFile()) {
                                QRCodeUtils.createPhotoAtCenter((Graphics2D)gs, (BufferedImage)bufImg, logo);
                            }
                            break block22;
                        }
                        throw new Exception("QRCode content bytes length = " + contentBytes.length + " not in [0, 800].");
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)Activator.getDefault(), e);
                        if (gs != null) {
                            try {
                                gs.dispose();
                            }
                            catch (Exception exception) {}
                        }
                        if (bufImg != null) {
                            bufImg.flush();
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (gs != null) {
                        try {
                            gs.dispose();
                        }
                        catch (Exception exception) {}
                    }
                    if (bufImg != null) {
                        bufImg.flush();
                    }
                    throw throwable;
                }
            }
            if (gs != null) {
                try {
                    gs.dispose();
                }
                catch (Exception exception) {}
            }
            if (bufImg != null) {
                bufImg.flush();
            }
        }
        return bufImg;
    }

    private static BufferedImage createPhotoAtCenter(Graphics2D gs, BufferedImage bufImg, File logo) throws Exception {
        BufferedImage im = ImageIO.read(logo);
        gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gs.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int imageWidth = im.getWidth(null);
        int imageHeight = im.getHeight(null);
        double max = 3.5;
        if ((double)imageWidth > (double)bufImg.getWidth() / max || (double)imageHeight > (double)bufImg.getHeight() / max) {
            if (imageWidth >= imageHeight) {
                imageHeight = (int)((double)imageHeight * ((double)bufImg.getWidth() / ((double)imageWidth * max)));
                imageWidth = (int)((double)bufImg.getWidth() / max);
            } else {
                imageWidth = (int)((double)imageWidth * ((double)bufImg.getWidth() / ((double)imageHeight * max)));
                imageHeight = (int)((double)bufImg.getHeight() / max);
            }
        }
        int centerX = bufImg.getMinX() + bufImg.getWidth() / 2 - imageWidth / 2;
        int centerY = bufImg.getMinY() + bufImg.getHeight() / 2 - imageHeight / 2;
        gs.setColor(Color.WHITE);
        RoundRectangle2D.Float roundedRectangle = new RoundRectangle2D.Float(centerX - 2, centerY - 2, imageWidth + 4, imageWidth + 4, 10.0f, 10.0f);
        gs.fill(roundedRectangle);
        gs.drawImage(im, centerX, centerY, imageWidth, imageHeight, null);
        bufImg.flush();
        return bufImg;
    }

    public static int getQRSize(int version, int dotSize, int borderSize) {
        return (21 + 4 * (version - 1)) * dotSize + borderSize * 2;
    }
}

