/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.UpgradeSchedulingRule;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ApplyProfileChangesDialog;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class PluginUtils {
    private static volatile boolean hasNotify = false;
    private static final String PLUGIN_REPOSITORIES = "PLUGIN_REPOSITORIES";
    public static final int INSTALL_JOB_PHP = 512;
    public static final int INSTALL_JOB_UPGRADE = 128;
    public static final int INSTALL_JOB_PLUGINS = 256;
    public static final int INSTALL_JOB_ALL = 896;
    private static final String FEATURE_IU_SUFFIX = ".feature.group";

    public static synchronized void notifyInstallPlugin(String pluginID, final String featureId, final String title, final String message, final String key, final boolean needOpenConfigmDialog) {
        final String updateSite = EclipseUtil.defaultScope().getNode("com.pandora.ui").get(PLUGIN_REPOSITORIES, null);
        if (!(!StringUtil.isNotBlank(updateSite) || needOpenConfigmDialog && hasNotify || PluginUtils.isPluginInstalled(pluginID) && PluginUtils.isFeatureInstalled(featureId))) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int result = -1;
                        Shell shell = Display.getDefault().getActiveShell();
                        if (needOpenConfigmDialog) {
                            hasNotify = true;
                            result = PluginUtils.openIgnoreMessageDialogConfirm(shell, title, message, Activator.getDefault().getPreferenceStore(), key);
                        }
                        if (!needOpenConfigmDialog || result != 1) {
                            int code = -1;
                            try {
                                String errorMessage = "\u8fde\u63a5\u63d2\u4ef6\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u5728\u7f51\u7edc\u6b63\u5e38\u540e\u5c1d\u8bd5\u4ece\u83dc\u5355\u3010\u5de5\u5177-\u63d2\u4ef6\u5b89\u88c5\u3011\u754c\u9762\u4e2d\u8fdb\u884c\u5b89\u88c5\uff0c\u5982\u4ecd\u63d0\u793a\u63d2\u4ef6\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\u5219\u91cd\u542fHBuilder\u518d\u6b21\u5c1d\u8bd5";
                                try {
                                    HttpURLConnection url = (HttpURLConnection)new URL(String.valueOf(updateSite) + "/site.xml").openConnection();
                                    url.setReadTimeout(1000);
                                    url.setConnectTimeout(1000);
                                    url.connect();
                                    code = url.getResponseCode();
                                }
                                catch (Exception e) {
                                    MessageDialog.openError((Shell)shell, (String)title, (String)errorMessage);
                                    HBLog.logError((Plugin)Activator.getDefault(), e);
                                    return;
                                }
                                if (code == 200) {
                                    PluginUtils.install(updateSite, featureId, "\u5b89\u88c5\u63d2\u4ef6", 256, true, 896);
                                } else {
                                    MessageDialog.openError((Shell)shell, (String)title, (String)errorMessage);
                                }
                            }
                            catch (Throwable ex) {
                                HBLog.logError((Plugin)Activator.getDefault(), ex);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                HBLog.logError((Plugin)Activator.getDefault(), e);
            }
        }
    }

    public static int openIgnoreMessageDialogConfirm(Shell shell, String title, String message, IPreferenceStore store, String key) {
        if (!store.getString(key).equals("true")) {
            MessageDialogWithToggle d = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)title, (String)message, (String)"\u4e0d\u518d\u63d0\u793a", (boolean)false, (IPreferenceStore)store, (String)key);
            store.setValue(key, String.valueOf(d.getToggleState()));
            if (d.getReturnCode() == 3) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    public static void install(final String updateSite, final String featureID, final String jobName, final int familys, final boolean needRestart, int conflictJobFamily) throws InvocationTargetException {
        final Job runnable = new Job(jobName){

            public boolean belongsTo(Object family) {
                try {
                    if (family != null && family instanceof Integer && (familys & (Integer)family) != 0) {
                        return true;
                    }
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)Activator.getDefault(), e);
                }
                return super.belongsTo(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                block6: {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                    sub.setTaskName(jobName);
                    try {
                        try {
                            boolean result = PluginUtils.installCommon(updateSite, featureID, jobName, monitor);
                            if (needRestart && result) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        int retCode = ApplyProfileChangesDialog.promptForRestart((Shell)ProvUI.getDefaultParentShell(), (boolean)true);
                                        if (retCode == 2) {
                                            PlatformUI.getWorkbench().restart();
                                        }
                                    }
                                });
                            }
                            sub.worked(3);
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)Activator.getDefault(), e);
                            sub.done();
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        sub.done();
                        throw throwable;
                    }
                    sub.done();
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        runnable.setRule((ISchedulingRule)UpgradeSchedulingRule.getSelfInstance());
        if (!PlatformUI.getWorkbench().isClosing()) {
            String name = PluginUtils.getInstallingJobName(conflictJobFamily);
            boolean show = StringUtil.isEmpty(name);
            if (show) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PlatformUI.getWorkbench().isClosing()) {
                            return;
                        }
                        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                        progressService.showInDialog(Display.getDefault().getActiveShell(), runnable);
                    }
                });
            }
            runnable.schedule();
        }
    }

    public static boolean installCommon(String updateSite, String featureID, String jobName, IProgressMonitor monitor) throws InvocationTargetException, URISyntaxException, ProvisionException {
        IQuery query;
        IQueryResult roots;
        URI siteURL;
        String profileId = "_SELF_";
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        IMetadataRepository repo = provisioningUI.loadMetadataRepository(siteURL = new URI(updateSite), true, (IProgressMonitor)new NullProgressMonitor());
        if (repo == null) {
            throw new ProvisionException("\u5143\u6570\u636erepo\u672a\u627e\u5230" + siteURL);
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)provisioningUI.getSession().getProvisioningAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        IArtifactRepository artifactRepo = artifactManager.loadRepository(siteURL, (IProgressMonitor)new NullProgressMonitor());
        if (artifactRepo == null) {
            throw new ProvisionException("Artifact repo \u6ca1\u6709\u627e\u5230" + siteURL);
        }
        if (!artifactManager.isEnabled(siteURL)) {
            artifactManager.setEnabled(siteURL, true);
        }
        if ((roots = repo.query(query = featureID == null ? QueryUtil.createIUQuery(null, (VersionRange)VersionRange.emptyRange) : QueryUtil.createIUQuery((String)(String.valueOf(featureID) + FEATURE_IU_SUFFIX), (VersionRange)VersionRange.emptyRange), monitor)).isEmpty()) {
            if (monitor.isCanceled()) {
                return false;
            }
            IProfile profile = ProvUI.getProfileRegistry((ProvisioningSession)provisioningUI.getSession()).getProfile(profileId);
            if (profile != null) {
                roots = profile.query(query, monitor);
            } else {
                HBLog.logError((Plugin)Activator.getDefault(), MessageFormat.format("Error while retrieving the profile for ''{0}'' update site", updateSite), new RuntimeException(MessageFormat.format("The profile for ''{0}'' was null", profileId)));
            }
        }
        if (roots != null && !roots.isEmpty()) {
            ArrayList result = new ArrayList();
            Set units = roots.toUnmodifiableSet();
            result.addAll(units);
            for (IInstallableUnit out : units) {
                for (IInstallableUnit in : units) {
                    if (in.equals((Object)out) || in.compareTo((Object)out) >= 0) continue;
                    result.remove(in);
                }
            }
            if (result.isEmpty() || monitor.isCanceled()) {
                return false;
            }
            ProvisioningContext context = new ProvisioningContext(provisioningUI.getSession().getProvisioningAgent());
            context.setMetadataRepositories(new URI[]{siteURL});
            context.setArtifactRepositories(new URI[]{siteURL});
            InstallOperation op = new InstallOperation(provisioningUI.getSession(), result);
            op.setProvisioningContext(context);
            IStatus status = op.resolveModal(monitor);
            HBLog.logError((Plugin)Activator.getDefault(), "\u4e0b\u8f7d\u63d2\u4ef6\uff1a " + featureID + ", result: " + status);
            if (status.getSeverity() == 4) {
                HBLog.logError((Plugin)Activator.getDefault(), status.toString());
                if (status.isMultiStatus()) {
                    IStatus[] childrens;
                    IStatus[] iStatusArray = childrens = status.getChildren();
                    int n = childrens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus children = iStatusArray[n2];
                        if (children.getCode() == 10005) {
                            return true;
                        }
                        ++n2;
                    }
                }
                throw new ProvisionException(status);
            }
            if (status.getSeverity() == 8) {
                return false;
            }
            if (status.isOK()) {
                status = op.getProvisioningJob(monitor).runModal(monitor);
                if (status.getSeverity() == 4) {
                    throw new ProvisionException(status);
                }
                if (status.isOK()) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getInstallingJobName(int family) {
        Job[] jobs = Job.getJobManager().find((Object)family);
        if (jobs != null && jobs.length > 0) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getState() == 4 || job.getState() == 2 || job.getState() == 1) {
                    return job.getName();
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isFeatureInstalled(String featureID) {
        block5: {
            if (!StringUtil.isBlank(featureID)) break block5;
            return false;
        }
        try {
            IProfileRegistry registry;
            IProfile profile;
            if (!featureID.endsWith(FEATURE_IU_SUFFIX)) {
                featureID = (String.valueOf(featureID) + FEATURE_IU_SUFFIX).toLowerCase();
            }
            if ((profile = (registry = ProvUI.getProfileRegistry((ProvisioningSession)ProvisioningUI.getDefaultUI().getSession())).getProfile("_SELF_")) != null) {
                IQueryResult alreadyInstalled = profile.query(QueryUtil.createIUQuery((String)featureID), null);
                return alreadyInstalled != null && !alreadyInstalled.isEmpty();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isPluginInstalled(String pluginID) {
        return Platform.getBundle((String)pluginID) != null;
    }
}

