/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LocalFileLink
implements IHyperlink {
    private File fFile;
    private int fFileOffset;
    private int fFileLength;
    private int fFileLineNumber;
    private String fEditorId;

    public LocalFileLink(File fFile, String fEditorId, int fFileOffset, int fFileLength, int fFileLineNumber) {
        this.fFile = fFile;
        this.fFileOffset = fFileOffset;
        this.fFileLength = fFileLength;
        this.fFileLineNumber = fFileLineNumber;
        this.fEditorId = fEditorId;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        block9: {
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                try {
                    IEditorPart editorPart = page.openEditor((IEditorInput)new FileStoreEditorInput((IFileStore)new LocalFile(this.fFile)), this.getEditorId(), true);
                    if (this.fFileLineNumber <= 0) break block9;
                    ITextEditor textEditor = null;
                    textEditor = editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
                    if (textEditor == null) break block9;
                    IEditorInput input = editorPart.getEditorInput();
                    if (this.fFileOffset < 0) {
                        IDocumentProvider provider = textEditor.getDocumentProvider();
                        try {
                            provider.connect((Object)input);
                        }
                        catch (CoreException e) {
                            HBLog.logError((Plugin)Activator.getDefault(), e);
                            return;
                        }
                        IDocument document = provider.getDocument((Object)input);
                        try {
                            IRegion region = document.getLineInformation(this.fFileLineNumber - 1);
                            this.fFileOffset = region.getOffset();
                            this.fFileLength = region.getLength();
                        }
                        catch (BadLocationException e) {
                            HBLog.logError((Plugin)Activator.getDefault(), e);
                        }
                        provider.disconnect((Object)input);
                    }
                    if (this.fFileOffset >= 0 && this.fFileLength >= 0) {
                        textEditor.selectAndReveal(this.fFileOffset, this.fFileLength);
                    }
                }
                catch (PartInitException e) {
                    HBLog.logError((Plugin)Activator.getDefault(), e);
                }
            }
        }
    }

    private String getEditorId() {
        if (this.fEditorId == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(this.fFile.getName());
            if (desc == null) {
                desc = workbench.getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
            }
            this.fEditorId = desc.getId();
        }
        return this.fEditorId;
    }
}

