/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.runtime.Plugin;

public class IOUtil {
    public static final String UTF_8 = "UTF-8";
    private static final int BUFFER_SIZE = 8192;

    public static String read(InputStream stream) {
        return IOUtil.read(stream, null);
    }

    /*
     * Loose catch block
     */
    public static String read(InputStream stream, String charset) {
        char[] bomBuffer;
        if (stream == null) {
            return null;
        }
        BufferedReader reader = null;
        if (charset == null) {
            if (stream.markSupported()) {
                CharsetDetector detector = new CharsetDetector();
                CharsetMatch match = detector.setText(stream).detect();
                charset = match.getName();
                reader = new BufferedReader(match.getReader());
            } else {
                charset = UTF_8;
                reader = new BufferedReader(new InputStreamReader(stream, charset));
            }
        } else {
            reader = new BufferedReader(new InputStreamReader(stream, charset));
        }
        StringBuilder output = new StringBuilder();
        if (charset.toUpperCase().equals(UTF_8) && reader.read(bomBuffer = new char[1]) != -1 && bomBuffer[0] != '\ufeff') {
            output.append(bomBuffer, 0, bomBuffer.length);
        }
        char[] buffer = new char[8192];
        int read = 0;
        while ((read = reader.read(buffer)) != -1) {
            output.append(buffer, 0, read);
        }
        String string = output.toString();
        try {
            if (reader != null) {
                reader.close();
            } else if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException e) {
            try {
                IOUtil.log(e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    } else if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                } else if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static void write(OutputStream stream, String rawSource) {
        IOUtil.write(stream, rawSource, null);
    }

    public static void write(OutputStream stream, String rawSource, String charset) {
        block17: {
            if (stream == null) {
                return;
            }
            if (rawSource == null) {
                rawSource = "";
            }
            if (charset == null) {
                charset = UTF_8;
            }
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new OutputStreamWriter(stream, charset);
                    writer.write(rawSource);
                }
                catch (IOException e) {
                    IOUtil.log(e);
                    try {
                        if (writer != null) {
                            ((Writer)writer).close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void log(Exception e) {
        if (Activator.getDefault() == null) {
            return;
        }
        HBLog.logError((Plugin)Activator.getDefault(), e);
    }
}

