/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.utils.ArrayUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionsUtil {
    public static <T, U> Map<T, U> getMapValue(Map<T, U> list) {
        if (list == null) {
            return Collections.emptyMap();
        }
        return list;
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !CollectionsUtil.isEmpty(collection);
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T, U> boolean isNotEmpty(Map<T, U> map) {
        return !CollectionsUtil.isEmpty(map);
    }

    public static <T, U> boolean isEmpty(Map<T, U> map) {
        return map == null || map.isEmpty();
    }

    public static final <T> List<T> newList(T ... items) {
        return CollectionsUtil.addToList(new ArrayList(items != null ? items.length : 0), items);
    }

    public static final <T, U extends T> List<T> addToList(List<T> list, U ... items) {
        if (list != null && items != null) {
            int i = 0;
            while (i < items.length) {
                list.add(items[i]);
                ++i;
            }
            if (list instanceof ArrayList) {
                ((ArrayList)list).trimToSize();
            }
        }
        return list;
    }

    public static final <T> Set<T> newInOrderSet(T ... items) {
        return CollectionsUtil.addToSet(new LinkedHashSet(items != null ? items.length : 0), items);
    }

    public static final <T, U extends T> Set<T> addToSet(Set<T> set, U ... items) {
        if (set != null && items != null) {
            int i = 0;
            while (i < items.length) {
                set.add(items[i]);
                ++i;
            }
        }
        return set;
    }

    public static final <T> Set<T> newSet(T ... items) {
        return CollectionsUtil.addToSet(new HashSet(items != null ? items.length : 0), items);
    }

    public static final <T> Map<T, T> newMap(T ... items) {
        return CollectionsUtil.addToMap(new HashMap(items != null ? items.length / 2 : 0), items);
    }

    public static final <T, U extends T> Map<T, T> addToMap(Map<T, T> map, U ... items) {
        if (map != null && items != null) {
            if (items.length % 2 != 0) {
                throw new IllegalArgumentException("Length of list of items must be multiple of 2");
            }
            int i = 0;
            while (i < items.length) {
                map.put(items[i], items[i + 1]);
                i += 2;
            }
        }
        return map;
    }

    public static final <T, U> Map<T, U> newTypedMap(Class<T> keyType, Class<U> valueType, Object ... items) {
        Map result;
        if (keyType != null && valueType != null && !ArrayUtils.isEmpty(items)) {
            result = new HashMap();
            CollectionsUtil.addToMap(keyType, valueType, result, items);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    public static final <T, U> void addToMap(Class<T> keyType, Class<U> valueType, Map<T, U> map, Object ... items) {
        if (keyType != null && valueType != null && map != null && !ArrayUtils.isEmpty(items)) {
            if (items.length % 2 != 0) {
                throw new IllegalArgumentException("Length of list of items must be multiple of 2");
            }
            int i = 0;
            while (i < items.length) {
                Object keyObject = items[i];
                if (!keyType.isAssignableFrom(keyObject.getClass())) {
                    String message = MessageFormat.format("Key {0} was not of the expected type: {1}", i, keyType);
                    throw new IllegalArgumentException(message);
                }
                T key = keyType.cast(keyObject);
                Object valueObject = items[i + 1];
                if (!valueType.isAssignableFrom(valueObject.getClass())) {
                    String message = MessageFormat.format("Value {0} was not of the expected type: {1}", i + 1, valueType);
                    throw new IllegalArgumentException(message);
                }
                U value = valueType.cast(valueObject);
                map.put(key, value);
                i += 2;
            }
        }
    }
}

