/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AnimationUtil {
    public static final long FADE_RESCHEDULE_DELAY = 40L;
    public static final int FADE_IN_INCREMENT = 30;
    public static final int FADE_OUT_INCREMENT = -20;

    public static FadeJob fastFadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 30, 40L, true, listener);
    }

    public static FadeJob fastFadeInWithoutMove(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 30, 40L, false, listener);
    }

    public static FadeJob fadeOut(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, -20, 40L, false, listener);
    }

    public static class FadeJob
    extends Job {
        private final Shell shell;
        private final int increment;
        private final boolean move;
        private volatile boolean stopped;
        private volatile int currentAlpha;
        private final long delay;
        private final IFadeListener fadeListener;
        private int movingDistance = 0;

        public FadeJob(Shell shell, int increment, long delay, boolean move, IFadeListener fadeListener) {
            super("Fading");
            if (increment < -255 || increment == 0 || increment > 255) {
                throw new IllegalArgumentException("-255 <= increment <= 255 && increment != 0");
            }
            if (delay < 1L) {
                throw new IllegalArgumentException("delay must be > 0");
            }
            this.currentAlpha = shell.getAlpha();
            this.shell = shell;
            this.increment = increment;
            this.move = move;
            this.delay = delay;
            this.fadeListener = fadeListener;
            this.setSystem(true);
            this.schedule(delay);
        }

        protected void canceling() {
            this.stopped = true;
        }

        private void reschedule() {
            if (this.stopped) {
                return;
            }
            this.schedule(this.delay);
        }

        public void cancelAndWait(final boolean setAlpha) {
            if (this.stopped) {
                return;
            }
            this.cancel();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (setAlpha) {
                        FadeJob.this.shell.setAlpha(FadeJob.this.getLastAlpha());
                    }
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.stopped) {
                return Status.OK_STATUS;
            }
            this.currentAlpha += this.increment;
            if (this.currentAlpha <= 0) {
                this.currentAlpha = 0;
            } else if (this.currentAlpha >= 255) {
                this.currentAlpha = 255;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (FadeJob.this.stopped) {
                        return;
                    }
                    if (FadeJob.this.shell.isDisposed()) {
                        FadeJob.this.stopped = true;
                        return;
                    }
                    FadeJob.this.shell.setAlpha(FadeJob.this.currentAlpha);
                    if (FadeJob.this.move) {
                        Point p = FadeJob.this.shell.getLocation();
                        FadeJob.this.shell.setLocation(p.x, p.y + -1);
                        FadeJob fadeJob = FadeJob.this;
                        fadeJob.movingDistance = fadeJob.movingDistance - 1;
                    }
                    if (FadeJob.this.fadeListener != null) {
                        FadeJob.this.fadeListener.faded(FadeJob.this.shell, FadeJob.this.currentAlpha);
                    }
                }
            });
            if (this.currentAlpha == 0 || this.currentAlpha == 255) {
                this.stopped = true;
            }
            this.reschedule();
            return Status.OK_STATUS;
        }

        private int getLastAlpha() {
            return this.increment < 0 ? 0 : 255;
        }

        public int getMovingDistance() {
            return this.movingDistance;
        }

        public void setMovingDistance(int movingDistance) {
            this.movingDistance = movingDistance;
        }
    }

    public static interface IFadeListener {
        public void faded(Shell var1, int var2);
    }
}

