/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications;

import com.pandora.core.log.HBLog;
import com.pandora.core.ui.notifications.AbstractNotification;
import com.pandora.core.ui.notifications.AbstractUiNotification;
import com.pandora.core.ui.notifications.internal.AbstractWorkbenchNotificationPopup;
import com.pandora.core.ui.notifications.internal.NotificationPopup;
import com.pandora.core.ui.notifications.internal.NotificationSink;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.StringUtil;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NotificationSender
extends NotificationSink {
    private static final boolean RUN_AS_SYSTEM_JOB = true;
    private static NotificationSender popupNotificationSink;
    private final WeakHashMap<String, OpenJob> openedEventJobs = new WeakHashMap();

    private NotificationSender() {
    }

    public static NotificationSender getInstance() {
        if (popupNotificationSink == null) {
            popupNotificationSink = new NotificationSender();
        }
        return popupNotificationSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(AbstractNotification ... notifications) {
        AbstractNotification[] abstractNotificationArray = notifications;
        int n = notifications.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNotification notification = abstractNotificationArray[n2];
            if (notification instanceof AbstractUiNotification) {
                OpenJob openJob = null;
                boolean hasEventId = StringUtil.isNotBlank(notification.getEventId());
                if (hasEventId && (openJob = this.openedEventJobs.get(notification.getEventId())) != null) {
                    openJob.cancel();
                    openJob.close();
                    try {
                        openJob.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                openJob = new OpenJob((AbstractUiNotification)notification);
                openJob.setSystem(true);
                openJob.schedule();
                if (hasEventId) {
                    WeakHashMap<String, OpenJob> weakHashMap = this.openedEventJobs;
                    synchronized (weakHashMap) {
                        this.openedEventJobs.put(notification.getEventId(), openJob);
                    }
                }
            }
            ++n2;
        }
    }

    private class OpenJob
    extends Job {
        private NotificationPopup popup;
        private AbstractUiNotification notification;

        public OpenJob(AbstractUiNotification notification) {
            super("");
            this.notification = notification;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display display = Display.getDefault();
            if (display == null || !Platform.isRunning()) {
                return Status.CANCEL_STATUS;
            }
            try {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = AbstractWorkbenchNotificationPopup.getNonModalShell();
                        if (shell != null) {
                            OpenJob.this.popup = new NotificationPopup(AbstractWorkbenchNotificationPopup.getNonModalShell());
                            OpenJob.this.popup.setFadingEnabled(true);
                            OpenJob.this.popup.setNotification(OpenJob.this.notification);
                            OpenJob.this.notification.setPopup(OpenJob.this.popup);
                            OpenJob.this.popup.setBlockOnOpen(false);
                            OpenJob.this.popup.addDisposeListener(new DisposeListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void widgetDisposed(DisposeEvent e) {
                                    if (StringUtil.isNotBlank(OpenJob.this.notification.getEventId())) {
                                        WeakHashMap weakHashMap = NotificationSender.this.openedEventJobs;
                                        synchronized (weakHashMap) {
                                            if (OpenJob.this.notification != null && NotificationSender.this.openedEventJobs.get(OpenJob.this.notification.getEventId()) == OpenJob.this) {
                                                NotificationSender.this.openedEventJobs.remove(OpenJob.this.notification.getEventId());
                                            }
                                        }
                                    }
                                    OpenJob.this.notification = null;
                                    OpenJob.this.popup = null;
                                }
                            });
                            OpenJob.this.popup.open();
                        }
                    }
                });
            }
            catch (Exception e) {
                HBLog.logError((Plugin)Activator.getDefault(), e);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        protected void close() {
            if (this.popup != null) {
                this.popup.close();
            }
        }
    }
}

