/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications;

import com.pandora.core.ui.notifications.AbstractUiNotification;
import com.pandora.core.ui.notifications.NotificationAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MessageNotification
extends AbstractUiNotification {
    private Image notificationImage;
    private Color titleForeground;
    private String title;
    private String label;
    private String desc;
    private int location = 1;
    private List<NotificationAction> actions = Collections.emptyList();
    private Runnable unhander;

    public MessageNotification(String title, String label, String desc) {
        super(null);
        this.title = title;
        this.label = label;
        this.desc = desc;
    }

    public MessageNotification(String title, String label, String desc, String eventId) {
        super(eventId);
        this.title = title;
        this.label = label;
        this.desc = desc;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public List<NotificationAction> getActions() {
        return this.actions;
    }

    public void setActions(List<NotificationAction> actions) {
        if (actions != null) {
            this.actions = actions;
        }
    }

    public void setActions(NotificationAction ... actions) {
        if (actions != null && actions.length > 0) {
            this.actions = Arrays.asList(actions);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void unhandled() {
        this.closeWithEvent();
        if (this.unhander != null) {
            this.unhander.run();
        }
    }

    @Override
    public Image getNotificationImage() {
        return this.notificationImage;
    }

    public void setNotificationImage(Image notificationImage) {
        this.notificationImage = notificationImage;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    @Override
    public Color getTitleForeground() {
        if (this.titleForeground != null) {
            return this.titleForeground;
        }
        return super.getTitleForeground();
    }

    public void setTitleForeground(Color titleForeground) {
        this.titleForeground = titleForeground;
    }

    public Runnable getUnhander() {
        return this.unhander;
    }

    public void setUnhander(Runnable unhander) {
        this.unhander = unhander;
    }

    @Override
    public Image getNotificationKindImage() {
        return null;
    }

    @Override
    public Point customPoint(Rectangle locationArea, Point notificationShellSize, Point defaultPonit) {
        return defaultPonit;
    }
}

