/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications;

import com.pandora.core.ui.notifications.AbstractNotification;
import com.pandora.core.ui.notifications.NotificationAction;
import com.pandora.core.ui.notifications.internal.NotificationPopup;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractUiNotification
extends AbstractNotification {
    public static final int LOCATION_WORKBENCH = 1;
    public static final int LOCATION_EDITOR = 2;
    private boolean unhandled = true;
    private long delayClose = -1L;
    private NotificationPopup popup;

    public AbstractUiNotification(String eventId) {
        super(eventId);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    public String getTitle() {
        return "Error Reporting";
    }

    public long getDelayClose() {
        return this.delayClose;
    }

    public void setDelayClose(long delayClose) {
        this.delayClose = delayClose;
    }

    public void setPopup(NotificationPopup popup) {
        this.popup = popup;
    }

    public NotificationPopup getPopup() {
        return this.popup;
    }

    public void closeWithEvent() {
        this.unhandled = false;
        NotificationPopup popup = this.getPopup();
        if (popup != null) {
            popup.close();
        }
    }

    public void unhandledIfCan() {
        if (this.unhandled) {
            this.unhandled();
        }
    }

    public void unhandled() {
    }

    public int getLocation() {
        return 1;
    }

    public Color getTitleForeground() {
        return Display.getDefault().getSystemColor(30);
    }

    public abstract Point customPoint(Rectangle var1, Point var2, Point var3);

    public abstract Image getNotificationImage();

    public abstract Image getNotificationKindImage();

    public abstract List<NotificationAction> getActions();
}

