/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterBlockWithBeginNode;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterCSSPunctuationNode
extends FormatterBlockWithBeginNode {
    private NodeTypes.TypePunctuation punctuationType;
    private boolean isLastNodeInDeclaration;

    public FormatterCSSPunctuationNode(IFormatterDocument document, NodeTypes.TypePunctuation punctuationType, boolean isLastNodeInDeclaration) {
        super(document);
        this.punctuationType = punctuationType;
        this.isLastNodeInDeclaration = isLastNodeInDeclaration;
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return true;
    }

    public int getSpacesCountBefore() {
        switch (this.punctuationType) {
            case CSS_CHILD_COMBINATOR: {
                return this.getDocument().getInt("css.formatter.spaces.before.child.combinator");
            }
            case SELECTOR_COLON: 
            case PROPERTY_COLON: {
                return this.getDocument().getInt("css.formatter.spaces.before.colon");
            }
            case COMMA: {
                return this.getDocument().getInt("css.formatter.spaces.before.commas");
            }
            case SEMICOLON: {
                return this.getDocument().getInt("css.formatter.spaces.before.semicolon");
            }
        }
        return super.getSpacesCountBefore();
    }

    public int getSpacesCountAfter() {
        if (this.isLastNodeInDeclaration) {
            return super.getSpacesCountBefore();
        }
        switch (this.punctuationType) {
            case CSS_CHILD_COMBINATOR: {
                return this.getDocument().getInt("css.formatter.spaces.after.child.combinator");
            }
            case SELECTOR_COLON: 
            case PROPERTY_COLON: {
                return this.getDocument().getInt("css.formatter.spaces.after.colon");
            }
            case COMMA: {
                return this.getDocument().getInt("css.formatter.spaces.after.commas");
            }
            case SEMICOLON: {
                return this.getDocument().getInt("css.formatter.spaces.after.semicolon");
            }
        }
        return super.getSpacesCountBefore();
    }

    protected int getBlankLinesAfter(IFormatterContext context) {
        return this.isLastNodeInDeclaration ? this.getInt("css.formatter.line.after.declaration") : super.getBlankLinesAfter(context);
    }
}

