/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter;

import com.aptana.editor.css.formatter.nodes.FormatterCSSAtRuleNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSBlockNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSDeclarationPropertyNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSDeclarationValueNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSParenthesesNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSPunctuationNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSRootNode;
import com.aptana.editor.css.formatter.nodes.FormatterCSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSErrorDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSFontFaceNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesNode;
import com.aptana.editor.css.parsing.ast.CSSMediaNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSPageNode;
import com.aptana.editor.css.parsing.ast.CSSPageSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSTermListNode;
import com.aptana.editor.css.parsing.ast.CSSTextNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.NodeTypes;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseRootNode;
import com.aptana.parsing.lexer.IRange;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;

public class CSSFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    private static final int MEDIA_AT_RULE_LENGTH = 6;
    private static final int PAGE_AT_RULE_LENGTH = 5;
    private FormatterDocument document;
    public static final HashSet<String> PUNCTUATION = new HashSet<String>(Arrays.asList(",", ";", ":", ")", "(", ">"));
    private static final Pattern NON_LETTER_PATTERN = Pattern.compile("[^a-zA-Z]");

    public IFormatterContainerNode build(IParseNode parseResult, FormatterDocument document) {
        this.document = document;
        FormatterCSSRootNode rootNode = new FormatterCSSRootNode((IFormatterDocument)document);
        this.start((IFormatterContainerNode)rootNode);
        IParseNode[] children = parseResult.getChildren();
        this.addNodes(children);
        this.checkedPop((IFormatterContainerNode)rootNode, document.getLength());
        if (parseResult instanceof IParseRootNode) {
            this.setOffOnRegions(this.resolveOffOnRegions((IParseRootNode)parseResult, (IFormatterDocument)document, "css.formatter.formatter.on.off.enabled", "css.formatter.formatter.off", "css.formatter.formatter.on"));
        }
        return rootNode;
    }

    private void addNodes(IParseNode[] children) {
        if (children == null || children.length == 0) {
            return;
        }
        IParseNode[] iParseNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            this.addNode(child);
            ++n2;
        }
    }

    private void addNode(IParseNode node) {
        CSSNode cssNode = (CSSNode)node;
        short type = cssNode.getNodeType();
        switch (type) {
            case 6: {
                this.pushFormatterRuleNode((CSSRuleNode)cssNode);
                break;
            }
            case 8: {
                this.pushFormatterPageNode((CSSPageNode)cssNode);
                break;
            }
            case 15: {
                this.pushFormatterFontFaceNode((CSSFontFaceNode)cssNode);
                break;
            }
            case 7: {
                this.pushFormatterMediaNode((CSSMediaNode)cssNode);
                break;
            }
            case 22: {
                this.pushFormatterMediaNode((CSSKeyFramesNode)cssNode);
                break;
            }
            case 3: 
            case 5: 
            case 16: 
            case 19: {
                this.pushAtRuleNode(cssNode);
                break;
            }
        }
    }

    private void pushAtRuleNode(CSSNode atRuleNode) {
        int length = this.document.getLength();
        int selectorStartingOffset = atRuleNode.getStartingOffset();
        int selectEndingOffset = atRuleNode.getEndingOffset();
        while (selectorStartingOffset < length) {
            char c = this.document.charAt(selectorStartingOffset);
            if (Character.isWhitespace(c) || c == '\'' || c == '\"') break;
            ++selectorStartingOffset;
        }
        selectorStartingOffset = this.getBeginWithoutWhiteSpaces(selectorStartingOffset, this.document);
        while (selectEndingOffset >= selectorStartingOffset) {
            if (!Character.isWhitespace(this.document.charAt(selectEndingOffset - 1))) break;
            --selectEndingOffset;
        }
        FormatterCSSAtRuleNode atNode = new FormatterCSSAtRuleNode((IFormatterDocument)this.document);
        atNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)atRuleNode.getStartingOffset(), (int)selectorStartingOffset));
        this.push((IFormatterContainerNode)atNode);
        this.checkedPop((IFormatterContainerNode)atNode, -1);
        FormatterCSSSelectorNode formatterSelectorNode = new FormatterCSSSelectorNode((IFormatterDocument)this.document, false, false);
        formatterSelectorNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)this.getBeginWithoutWhiteSpaces(selectorStartingOffset, this.document), (int)(this.getEndWithoutWhiteSpaces(selectEndingOffset, this.document) + 1)));
        this.push((IFormatterContainerNode)formatterSelectorNode);
        this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, selectEndingOffset, false);
        this.checkedPop((IFormatterContainerNode)formatterSelectorNode, -1);
    }

    private void pushFormatterMediaNode(CSSMediaNode mediaNode) {
        FormatterCSSAtRuleNode atNode = new FormatterCSSAtRuleNode((IFormatterDocument)this.document);
        int mediaNodeStart = mediaNode.getStartingOffset();
        atNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)mediaNodeStart, (int)(mediaNodeStart + 6)));
        this.push((IFormatterContainerNode)atNode);
        this.checkedPop((IFormatterContainerNode)atNode, -1);
        CSSTextNode[] medias = mediaNode.getMedias();
        int blockStartOffset = this.getBlockStartOffset(medias[medias.length - 1].getEndingOffset() + 1, this.document);
        this.pushFormatterMediaSelectorNodes(medias, 0);
        FormatterCSSBlockNode formatterBlockNode = new FormatterCSSBlockNode((IFormatterDocument)this.document, false);
        formatterBlockNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)blockStartOffset, (int)(blockStartOffset + 1)));
        this.push((IFormatterContainerNode)formatterBlockNode);
        CSSNode[] statements = mediaNode.getStatements();
        this.addNodes((IParseNode[])statements);
        if (statements.length > 0) {
            formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(statements[statements.length - 1].getEndingOffset() + 1), (int)mediaNode.getEndingOffset()));
        }
        this.checkedPop((IFormatterContainerNode)formatterBlockNode, mediaNode.getEndingOffset());
        formatterBlockNode.setEnd(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)mediaNode.getEndingOffset(), (int)(mediaNode.getEndingOffset() + 1)));
    }

    private void pushFormatterMediaNode(CSSKeyFramesNode mediaNode) {
        FormatterCSSAtRuleNode atNode = new FormatterCSSAtRuleNode((IFormatterDocument)this.document);
        int mediaNodeStart = mediaNode.getStartingOffset();
        atNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)mediaNodeStart, (int)(mediaNodeStart + 6)));
        this.push((IFormatterContainerNode)atNode);
        this.checkedPop((IFormatterContainerNode)atNode, -1);
        CSSTextNode media = mediaNode.getAnimationName();
        int blockStartOffset = this.getBlockStartOffset(media.getEndingOffset() + 1, this.document);
        FormatterCSSBlockNode formatterBlockNode = new FormatterCSSBlockNode((IFormatterDocument)this.document, false);
        formatterBlockNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)blockStartOffset, (int)(blockStartOffset + 1)));
        this.push((IFormatterContainerNode)formatterBlockNode);
        CSSNode[] statements = mediaNode.getStatements();
        this.addNodes((IParseNode[])statements);
        if (statements.length > 0) {
            formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(statements[statements.length - 1].getEndingOffset() + 1), (int)mediaNode.getEndingOffset()));
        }
        this.checkedPop((IFormatterContainerNode)formatterBlockNode, -1);
        formatterBlockNode.setEnd(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)mediaNode.getEndingOffset(), (int)(mediaNode.getEndingOffset() + 1)));
    }

    private int pushFormatterMediaSelectorNodes(CSSTextNode[] medias, int startIndex) {
        boolean previousNodeIsPunctuation = startIndex > 0;
        int lastMediaIndex = startIndex;
        while (lastMediaIndex < medias.length) {
            CSSTextNode mediaSelectorNode = medias[lastMediaIndex];
            String selectorText = mediaSelectorNode.getText();
            if (selectorText.length() == 1 && NON_LETTER_PATTERN.matcher(selectorText).matches()) {
                NodeTypes.TypePunctuation punctuation = this.getTypePunctuationForChar(selectorText.charAt(0));
                if (punctuation != null) {
                    this.findAndPushPunctuationNode(punctuation, mediaSelectorNode.getStartingOffset(), false);
                } else if (selectorText.charAt(0) == '(') {
                    int openParen = mediaSelectorNode.getStartingOffset();
                    FormatterCSSParenthesesNode parenthesisNode = new FormatterCSSParenthesesNode((IFormatterDocument)this.document);
                    parenthesisNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)openParen, (int)(openParen + 1)));
                    this.push((IFormatterContainerNode)parenthesisNode);
                    lastMediaIndex = this.pushFormatterMediaSelectorNodes(medias, lastMediaIndex + 1);
                    this.checkedPop((IFormatterContainerNode)parenthesisNode, -1);
                    if (lastMediaIndex >= medias.length) break;
                    mediaSelectorNode = medias[lastMediaIndex];
                    parenthesisNode.setEnd(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)mediaSelectorNode.getStartingOffset(), (int)(mediaSelectorNode.getStartingOffset() + 1)));
                } else if (selectorText.charAt(0) == ')') {
                    return lastMediaIndex;
                }
                previousNodeIsPunctuation = true;
            } else {
                FormatterCSSSelectorNode formatterSelectorNode = new FormatterCSSSelectorNode((IFormatterDocument)this.document, false, previousNodeIsPunctuation);
                formatterSelectorNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)this.getBeginWithoutWhiteSpaces(mediaSelectorNode.getStartingOffset(), this.document), (int)(this.getEndWithoutWhiteSpaces(mediaSelectorNode.getEndingOffset() + 1, this.document) + 1)));
                this.push((IFormatterContainerNode)formatterSelectorNode);
                this.checkedPop((IFormatterContainerNode)formatterSelectorNode, -1);
                previousNodeIsPunctuation = false;
            }
            ++lastMediaIndex;
        }
        return lastMediaIndex;
    }

    private void pushFormatterFontFaceNode(CSSFontFaceNode faceFontNode) {
        CSSDeclarationNode[] declarations = faceFontNode.getDeclarations();
        int blockStartOffset = this.getBlockStartOffset(faceFontNode.getStartingOffset() + 9, this.document);
        FormatterCSSAtRuleNode atFontFaceNode = new FormatterCSSAtRuleNode((IFormatterDocument)this.document);
        atFontFaceNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)this.getBeginWithoutWhiteSpaces(faceFontNode.getStartingOffset(), this.document), (int)(this.getEndWithoutWhiteSpaces(faceFontNode.getStartingOffset() + 9, this.document) + 1)));
        this.push((IFormatterContainerNode)atFontFaceNode);
        this.checkedPop((IFormatterContainerNode)atFontFaceNode, -1);
        FormatterCSSBlockNode formatterBlockNode = new FormatterCSSBlockNode((IFormatterDocument)this.document, false);
        formatterBlockNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)blockStartOffset, (int)(blockStartOffset + 1)));
        this.push((IFormatterContainerNode)formatterBlockNode);
        if (declarations != null && declarations.length != 0 && this.getBeginWithoutWhiteSpaces(blockStartOffset + 1, this.document) < declarations[0].getStartingOffset()) {
            formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(blockStartOffset + 1), (int)declarations[0].getStartingOffset()));
        }
        this.pushFormatterDeclarationNodes(faceFontNode.getEndingOffset(), declarations, formatterBlockNode);
        this.checkedPop((IFormatterContainerNode)formatterBlockNode, -1);
        formatterBlockNode.setEnd(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)faceFontNode.getEndingOffset(), (int)(faceFontNode.getEndingOffset() + 1)));
    }

    private void pushFormatterPageNode(CSSPageNode pageNode) {
        FormatterCSSAtRuleNode atNode = new FormatterCSSAtRuleNode((IFormatterDocument)this.document);
        int pageNodeStart = pageNode.getStartingOffset();
        atNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)pageNodeStart, (int)(pageNodeStart + 5)));
        this.push((IFormatterContainerNode)atNode);
        this.checkedPop((IFormatterContainerNode)atNode, -1);
        CSSPageSelectorNode selector = pageNode.getSelector();
        CSSDeclarationNode[] declarations = pageNode.getDeclarations();
        int blockStartOffset = this.getBlockStartOffset(pageNodeStart + 1, this.document);
        if (selector != null) {
            blockStartOffset = this.getBlockStartOffset(selector.getEndingOffset() + 1, this.document);
            FormatterCSSSelectorNode formatterSelectorNode = new FormatterCSSSelectorNode((IFormatterDocument)this.document, true, false);
            formatterSelectorNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)this.getBeginWithoutWhiteSpaces(pageNodeStart, this.document), (int)(this.getEndWithoutWhiteSpaces(pageNodeStart + 5, this.document) + 1)));
            this.push((IFormatterContainerNode)formatterSelectorNode);
            this.checkedPop((IFormatterContainerNode)formatterSelectorNode, -1);
            formatterSelectorNode = new FormatterCSSSelectorNode((IFormatterDocument)this.document, false, false);
            formatterSelectorNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)this.getBeginWithoutWhiteSpaces(selector.getStartingOffset() - 1, this.document), (int)(this.getEndWithoutWhiteSpaces(selector.getEndingOffset() + 1, this.document) + 1)));
            this.push((IFormatterContainerNode)formatterSelectorNode);
            this.checkedPop((IFormatterContainerNode)formatterSelectorNode, -1);
        }
        FormatterCSSBlockNode formatterBlockNode = new FormatterCSSBlockNode((IFormatterDocument)this.document, false);
        formatterBlockNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)blockStartOffset, (int)(blockStartOffset + 1)));
        this.push((IFormatterContainerNode)formatterBlockNode);
        if (declarations != null && declarations.length != 0 && this.getBeginWithoutWhiteSpaces(blockStartOffset + 1, this.document) < declarations[0].getStartingOffset()) {
            formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(blockStartOffset + 1), (int)declarations[0].getStartingOffset()));
        }
        this.pushFormatterDeclarationNodes(pageNode.getEndingOffset(), declarations, formatterBlockNode);
        this.checkedPop((IFormatterContainerNode)formatterBlockNode, -1);
        formatterBlockNode.setEnd(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)pageNode.getEndingOffset(), (int)(pageNode.getEndingOffset() + 1)));
    }

    private void pushFormatterRuleNode(CSSRuleNode ruleNode) {
        CSSSelectorNode[] selectors = ruleNode.getSelectors();
        CSSDeclarationNode[] declarations = ruleNode.getDeclarations();
        int blockStartOffset = this.getBlockStartOffset(selectors[selectors.length - 1].getEndingOffset() + 1, this.document);
        this.pushFormatterSelectorNodes(selectors);
        boolean isDeclaration = ruleNode.getParent() == null || !(ruleNode.getParent() instanceof ParseRootNode);
        FormatterCSSBlockNode formatterBlockNode = new FormatterCSSBlockNode((IFormatterDocument)this.document, isDeclaration);
        formatterBlockNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)blockStartOffset, (int)(blockStartOffset + 1)));
        this.push((IFormatterContainerNode)formatterBlockNode);
        if (declarations != null && declarations.length != 0 && this.getBeginWithoutWhiteSpaces(blockStartOffset + 1, this.document) < declarations[0].getStartingOffset()) {
            formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(blockStartOffset + 1), (int)declarations[0].getStartingOffset()));
        }
        this.pushFormatterDeclarationNodes(ruleNode.getEndingOffset(), declarations, formatterBlockNode);
        this.checkedPop((IFormatterContainerNode)formatterBlockNode, ruleNode.getEndingOffset());
        formatterBlockNode.setEnd(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)ruleNode.getEndingOffset(), (int)(ruleNode.getEndingOffset() + 1)));
    }

    private void pushFormatterDeclarationNodes(int parentEndOffset, CSSDeclarationNode[] declarations, FormatterBlockWithBeginEndNode formatterBlockNode) {
        int i = 0;
        while (i < declarations.length) {
            CSSDeclarationNode declarationNode = declarations[i];
            CSSExpressionNode expressionNode = declarationNode.getAssignedValue();
            if (declarationNode instanceof CSSErrorDeclarationNode) {
                formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)declarationNode.getStartingOffset(), (int)(declarationNode.getEndingOffset() + 1)));
                this.findAndPushCommentsBetweenDeclarations(parentEndOffset, declarations, formatterBlockNode, i);
            } else {
                FormatterCSSDeclarationPropertyNode formatterDeclarationPropertyNode = new FormatterCSSDeclarationPropertyNode((IFormatterDocument)this.document);
                int propertyEndOffset = this.getEndWithoutWhiteSpaces(this.locateCharacterInSameLine(':', declarationNode.getStartingOffset(), this.document), this.document);
                formatterDeclarationPropertyNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)declarationNode.getStartingOffset(), (int)(propertyEndOffset + 1)));
                this.push((IFormatterContainerNode)formatterDeclarationPropertyNode);
                this.checkedPop((IFormatterContainerNode)formatterDeclarationPropertyNode, -1);
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.PROPERTY_COLON, propertyEndOffset, false);
                if (expressionNode != null) {
                    if (expressionNode instanceof CSSTermListNode) {
                        this.pushTermListNode((CSSTermListNode)expressionNode, i == declarations.length - 1);
                    } else {
                        this.pushDeclarationValueNode(expressionNode, i == declarations.length - 1);
                    }
                    IRange statusRange = declarationNode.getStatusRange();
                    if (declarationNode.getStatus() != null) {
                        formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)statusRange.getStartingOffset(), (int)(statusRange.getEndingOffset() + 1)));
                    }
                }
                if (this.document.charAt(declarationNode.getEndingOffset()) == ';') {
                    this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, declarationNode.getEndingOffset(), true);
                }
                this.findAndPushCommentsBetweenDeclarations(parentEndOffset, declarations, formatterBlockNode, i);
            }
            ++i;
        }
    }

    private void findAndPushCommentsBetweenDeclarations(int parentEndOffset, CSSDeclarationNode[] declarations, FormatterBlockWithBeginEndNode formatterBlockNode, int currentDeclarationIndex) {
        if (currentDeclarationIndex + 1 < declarations.length) {
            if (this.getBeginWithoutWhiteSpaces(declarations[currentDeclarationIndex].getEndingOffset() + 1, this.document) < declarations[currentDeclarationIndex + 1].getStartingOffset()) {
                formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(declarations[currentDeclarationIndex].getEndingOffset() + 1), (int)declarations[currentDeclarationIndex + 1].getStartingOffset()));
            }
        } else if (this.getBeginWithoutWhiteSpaces(declarations[currentDeclarationIndex].getEndingOffset() + 1, this.document) < parentEndOffset) {
            formatterBlockNode.addChild((IFormatterNode)CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)(declarations[currentDeclarationIndex].getEndingOffset() + 1), (int)parentEndOffset));
        }
    }

    private void pushDeclarationValueNode(CSSExpressionNode expressionNode, boolean isLastDeclaration) {
        int expressionEndOffset = expressionNode.getEndingOffset();
        int semicolonLocation = CSSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)this.document, (int)(expressionEndOffset + 1), (char)';', (boolean)false);
        int commaLocation = CSSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)this.document, (int)(expressionEndOffset + 1), (char)',', (boolean)false);
        int forwardSlashLocation = CSSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)this.document, (int)(expressionEndOffset + 1), (char)'/', (boolean)false);
        int LFLocation = CSSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)this.document, (int)(expressionEndOffset + 1), (char)'\n', (boolean)false);
        int CRLocation = CSSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)this.document, (int)(expressionEndOffset + 1), (char)'\r', (boolean)false);
        boolean endsWithSemicolon = false;
        boolean endsWithComma = false;
        boolean endsWithSlash = false;
        boolean isLastNodeInDeclaration = false;
        if (this.document.charAt(semicolonLocation) == ';') {
            endsWithSemicolon = true;
        }
        if (this.document.charAt(commaLocation) == ',') {
            endsWithComma = true;
        }
        if (this.document.charAt(forwardSlashLocation) == '/') {
            endsWithSlash = true;
        }
        if (this.document.charAt(forwardSlashLocation) == '/') {
            endsWithSlash = true;
        }
        if ((this.document.charAt(LFLocation) == '\n' || this.document.charAt(CRLocation) == '\r') && isLastDeclaration) {
            isLastNodeInDeclaration = true;
        }
        FormatterCSSDeclarationValueNode formatterDeclarationValueNode = new FormatterCSSDeclarationValueNode((IFormatterDocument)this.document, isLastNodeInDeclaration, endsWithComma || endsWithSemicolon || endsWithSlash);
        formatterDeclarationValueNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)expressionNode.getStartingOffset(), (int)(expressionNode.getEndingOffset() + 1)));
        this.push((IFormatterContainerNode)formatterDeclarationValueNode);
        this.checkedPop((IFormatterContainerNode)formatterDeclarationValueNode, -1);
        if (endsWithComma) {
            this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.COMMA, commaLocation, false);
        }
    }

    private void pushTermListNode(CSSTermListNode termListNode, boolean isLastDeclaration) {
        CSSExpressionNode leftExpression = termListNode.getLeftExpression();
        CSSExpressionNode rightExpression = termListNode.getRightExpression();
        if (leftExpression instanceof CSSTermListNode) {
            this.pushTermListNode((CSSTermListNode)leftExpression, isLastDeclaration);
            this.pushDeclarationValueNode(rightExpression, isLastDeclaration);
        } else {
            this.pushDeclarationValueNode(leftExpression, isLastDeclaration);
            this.pushDeclarationValueNode(rightExpression, isLastDeclaration);
        }
    }

    private void pushFormatterSelectorNodes(CSSSelectorNode[] selectors) {
        int i = 0;
        while (i < selectors.length) {
            CSSSelectorNode selectorNode = selectors[i];
            FormatterCSSSelectorNode formatterSelectorNode = new FormatterCSSSelectorNode((IFormatterDocument)this.document, i == 0, false);
            int selectorEndOffset = this.getEndWithoutWhiteSpaces(selectorNode.getEndingOffset() + 1, this.document) + 1;
            formatterSelectorNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)this.getBeginWithoutWhiteSpaces(selectorNode.getStartingOffset(), this.document), (int)selectorEndOffset));
            this.push((IFormatterContainerNode)formatterSelectorNode);
            this.checkedPop((IFormatterContainerNode)formatterSelectorNode, -1);
            int nextNonWhiteSpaceOffset = this.getBeginWithoutWhiteSpaces(selectorEndOffset, this.document);
            NodeTypes.TypePunctuation punctuation = this.getTypePunctuationForChar(this.document.charAt(nextNonWhiteSpaceOffset));
            if (punctuation != null) {
                this.findAndPushPunctuationNode(punctuation, nextNonWhiteSpaceOffset, false);
            }
            ++i;
        }
    }

    private NodeTypes.TypePunctuation getTypePunctuationForChar(char punctuation) {
        switch (punctuation) {
            case ',': {
                return NodeTypes.TypePunctuation.COMMA;
            }
            case ';': {
                return NodeTypes.TypePunctuation.SEMICOLON;
            }
            case ':': {
                return NodeTypes.TypePunctuation.SELECTOR_COLON;
            }
            case '>': {
                return NodeTypes.TypePunctuation.CSS_CHILD_COMBINATOR;
            }
        }
        return null;
    }

    private void findAndPushPunctuationNode(NodeTypes.TypePunctuation type, int offsetToSearch, boolean isEndofDeclarationNode) {
        char punctuationType = type.toString().charAt(0);
        int punctuationOffset = CSSFormatterNodeBuilder.locateCharForward((FormatterDocument)this.document, (char)punctuationType, (int)offsetToSearch);
        if (punctuationOffset != offsetToSearch || this.document.charAt(punctuationOffset) == punctuationType) {
            FormatterCSSPunctuationNode punctuationNode = new FormatterCSSPunctuationNode((IFormatterDocument)this.document, type, isEndofDeclarationNode);
            punctuationNode.setBegin(CSSFormatterNodeBuilder.createTextNode((IFormatterDocument)this.document, (int)punctuationOffset, (int)(punctuationOffset + 1)));
            this.push((IFormatterContainerNode)punctuationNode);
            this.checkedPop((IFormatterContainerNode)punctuationNode, -1);
        }
    }

    private int getBlockStartOffset(int offset, FormatterDocument document) {
        int length = document.getLength();
        while (offset < length) {
            if (document.charAt(offset) == '{') break;
            ++offset;
        }
        return offset;
    }

    private int getBeginWithoutWhiteSpaces(int offset, FormatterDocument document) {
        int length = document.getLength();
        while (offset < length) {
            if (!Character.isWhitespace(document.charAt(offset))) break;
            ++offset;
        }
        return offset;
    }

    private int getEndWithoutWhiteSpaces(int offset, FormatterDocument document) {
        while (offset > 0) {
            if (!Character.isWhitespace(document.charAt(offset)) && document.charAt(offset) != '{' && !PUNCTUATION.contains(Character.toString(document.charAt(offset)))) break;
            --offset;
        }
        return offset;
    }

    private int locateCharacterInSameLine(char character, int offset, FormatterDocument document) {
        int i = offset;
        while (i < document.getLength()) {
            char c = document.charAt(i);
            if (c == character) {
                return i;
            }
            if (c == '\n' || c == '\r') break;
            ++i;
        }
        return offset;
    }
}

