/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.css.CSSSourceViewerConfiguration;
import com.aptana.editor.css.formatter.CSSFormatter;
import com.aptana.editor.css.formatter.CSSFormatterPlugin;
import com.aptana.editor.css.formatter.preferences.CSSFormatterModifyDialog;
import com.aptana.formatter.AbstractScriptFormatterFactory;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSSFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final PreferenceKey FORMATTER_PREF_KEY = new PreferenceKey("com.aptana.editor.css.formatter", "css.formatter");
    private static final String FORMATTER_PREVIEW_FILE = "formatterPreview.css";
    private static final String[] KEYS = new String[]{"css.formatter.formatter.indentation.size", "css.formatter.formatter.tabulation.char", "css.formatter.formatter.tabulation.size", "css.formatter.wrap.comments", "css.formatter.wrap.comments.length", "css.formatter.indent.blocks", "css.formatter.line.after.element", "css.formatter.line.preserve", "css.formatter.line.after.declaration", "css.formatter.spaces.after.child.combinator", "css.formatter.spaces.after.commas", "css.formatter.spaces.after.parentheses", "css.formatter.spaces.after.colon", "css.formatter.spaces.after.semicolon", "css.formatter.spaces.before.child.combinator", "css.formatter.spaces.before.commas", "css.formatter.spaces.before.parentheses", "css.formatter.spaces.before.colon", "css.formatter.spaces.before.semicolon", "css.formatter.formatter.on.off.enabled", "css.formatter.formatter.on", "css.formatter.formatter.off"};

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            result[i] = new PreferenceKey("com.aptana.editor.css.formatter", key);
            ++i;
        }
        return result;
    }

    public IScriptFormatter createFormatter(String lineSeparator, Map<String, String> preferences) {
        return new CSSFormatter(lineSeparator, preferences, this.getMainContentType());
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(FORMATTER_PREVIEW_FILE);
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new CSSFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public SourceViewerConfiguration createSimpleSourceViewerConfiguration(ISharedTextColors colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new CSSSourceViewerConfiguration(preferenceStore, (AbstractThemeableEditor)editor);
    }

    public PreferenceKey getFormatterPreferenceKey() {
        return FORMATTER_PREF_KEY;
    }

    public IPreferenceStore getPreferenceStore() {
        return CSSFormatterPlugin.getDefault().getPreferenceStore();
    }

    public Object getPartitioningConfiguration() {
        return CSSSourceConfiguration.getDefault();
    }

    protected IEclipsePreferences getEclipsePreferences() {
        return EclipseUtil.instanceScope().getNode("com.aptana.editor.css");
    }

    protected String getFormatterTabPolicy(Map<String, String> preferences) {
        return preferences.get("css.formatter.formatter.tabulation.char");
    }

    protected int getEditorTabSize() {
        return EditorUtil.getSpaceIndentSize((String)CSSPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected int getDefaultEditorTabSize() {
        return EditorUtil.getDefaultSpaceIndentSize((String)CSSPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected String getFormatterTabSizeKey() {
        return "css.formatter.formatter.tabulation.size";
    }

    public boolean isContributingToUI() {
        return false;
    }
}

