/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.formatter.CSSFormatterContext;
import com.aptana.editor.css.formatter.CSSFormatterNodeBuilder;
import com.aptana.editor.css.formatter.CSSFormatterNodeRewriter;
import com.aptana.editor.css.formatter.CSSFormatterPlugin;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.ScriptFormattingContextProperties;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class CSSFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    private static final Pattern whiteSpaceAsterisk = Pattern.compile("[\\s\\*\\u00A0]");
    private static volatile boolean hasLaodScript = false;
    protected static final String[] SPACES = new String[]{"css.formatter.spaces.after.child.combinator", "css.formatter.spaces.after.commas", "css.formatter.spaces.after.parentheses", "css.formatter.spaces.after.colon", "css.formatter.spaces.after.semicolon", "css.formatter.spaces.before.child.combinator", "css.formatter.spaces.before.commas", "css.formatter.spaces.before.parentheses", "css.formatter.spaces.before.colon", "css.formatter.spaces.before.semicolon"};

    protected CSSFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    protected void loadScript() {
        block13: {
            if (!hasLaodScript) {
                hasLaodScript = true;
                InputStreamReader reader = null;
                try {
                    try {
                        reader = new FileReader(FileLocator.toFileURL((URL)CSSFormatterPlugin.getDefault().getBundle().getEntry("/resource/beautify-css.js")).getFile());
                        scriptContext.evaluateReader(scriptScope, (Reader)reader, "beautify css", 1, null);
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CSSFormatterPlugin.getDefault(), (Throwable)e);
                        if (reader == null) break block13;
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)source).getRootNode();
            if (parseResult != null) {
                CSSFormatterNodeBuilder builder = new CSSFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new CSSFormatterNodeRewriter(parseResult, formatterDocument).rewrite(root);
                CSSFormatterContext context = new CSSFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        block11: {
            Integer lastOffset = (Integer)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_LAST_FORMAT_OFFSET);
            Integer lastLength = (Integer)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_LAST_FORMAT_LENGTH);
            if (lastOffset != null && lastLength != null && lastOffset <= offset && lastLength >= length) {
                return null;
            }
            boolean isSlave = (Boolean)context.getProperty((Object)"formatting.context.isSlave");
            if (isSlave && isSelection) {
                offset = (Integer)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_SELECTION_OFFSET);
                length = (Integer)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_SELECTION_LENGTH);
            }
            if (isSelection) {
                IDocument document = (IDocument)context.getProperty((Object)ScriptFormattingContextProperties.CONTEXT_DOCUMENT);
                try {
                    IRegion regin = document.getLineInformationOfOffset(offset);
                    String indent = document.get(regin.getOffset(), offset - regin.getOffset());
                    if (StringUtil.isBlank((String)indent)) {
                        length = offset - regin.getOffset() + length;
                        offset = regin.getOffset();
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CSSFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
                }
            }
            String input = new String(source.substring(offset, offset + length));
            try {
                String tab = "\t";
                int size = 1;
                if (this.isEditorInsertSpacesForTabs()) {
                    tab = " ";
                    size = this.getEditorSpecificTabWidth();
                }
                Object options = scriptContext.evaluateString(scriptScope, "({'indent_size':" + size + ",'indent_char':'" + tab + "'})", null, 0, null);
                String output = (String)NativeObject.callMethod((Scriptable)((Scriptable)scriptScope.get("global", scriptScope)), (String)"css_beautify", (Object[])new Object[]{input, options});
                if (output == null) break block11;
                if (!input.equals(output)) {
                    if (this.equalsIgnoreWhiteSpaceAndAsterisk(input, output)) {
                        return new ReplaceEdit(offset, length, output);
                    }
                    this.logError(input, output);
                    break block11;
                }
                return new MultiTextEdit();
            }
            catch (Exception e) {
                StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
                IdeLog.logError((Plugin)CSSFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
        }
        return null;
    }

    public int getIndentSize() {
        return 1;
    }

    public String getIndentType() {
        return "tab";
    }

    public int getTabSize() {
        return 1;
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)CSSPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)CSSPlugin.getDefault().getPreferenceStore());
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("css.formatter.formatter.tabulation.size", this.getInt("css.formatter.formatter.tabulation.size"));
        document.setBoolean("css.formatter.wrap.comments", this.getBoolean("css.formatter.wrap.comments"));
        document.setString("css.formatter.indent.blocks", this.getString("css.formatter.indent.blocks"));
        document.setInt("css.formatter.line.after.element", this.getInt("css.formatter.line.after.element"));
        document.setInt("css.formatter.line.after.declaration", this.getInt("css.formatter.line.after.declaration"));
        document.setInt(ScriptFormattingContextProperties.CONTEXT_ORIGINAL_OFFSET, offset);
        document.setBoolean("css.formatter.formatter.on.off.enabled", this.getBoolean("css.formatter.formatter.on.off.enabled"));
        document.setString("css.formatter.formatter.on", this.getString("css.formatter.formatter.on"));
        document.setString("css.formatter.formatter.off", this.getString("css.formatter.formatter.off"));
        String[] stringArray = SPACES;
        int n = SPACES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            document.setInt(key, this.getInt(key));
            ++n2;
        }
        return document;
    }

    private boolean equalsIgnoreWhiteSpaceAndAsterisk(String in, String out) {
        if (in == null || out == null) {
            return in == out;
        }
        boolean result = (in = whiteSpaceAsterisk.matcher(in).replaceAll("")).equals(out = whiteSpaceAsterisk.matcher(out).replaceAll(""));
        if (!result) {
            FormatterUtils.logDiff((String)in, (String)out);
        }
        return result;
    }
}

