/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui.menu;

import com.pandora.core.utils.ProjectUtils;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.MobileEventAdapter;
import com.pandora.launcher.core.internal.Mobile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.wb.swt.ResourceManager;

public class MobileMenuAction
extends MobileEventAdapter
implements SelectionListener,
IMobileListener {
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_DEBUGING = 2;
    public static final int STATUS_STOPED = -1;
    private Mobile mobile = null;
    private MenuItem runItem = null;
    private MenuItem stopItem = null;
    private IProject project = null;
    private int status = -1;

    public MobileMenuAction(Mobile mobile) {
        this.mobile = mobile;
        DefaultMobileManager.getInstance().addMobileListener((IMobileListener)this);
    }

    public void initialContents(Menu menu, MenuItem parent) {
        this.runItem = new MenuItem(menu, 8);
        this.runItem.setText("Run in Device");
        this.runItem.setImage(ResourceManager.getPluginImage((String)"com.pandora.launcher.ui", (String)"icons/enable/run_exc.gif"));
        this.runItem.setEnabled(this.status == -1);
        this.runItem.addSelectionListener((SelectionListener)this);
        this.stopItem = new MenuItem(menu, 8);
        this.stopItem.setText("Stop");
        this.stopItem.setImage(ResourceManager.getPluginImage((String)"com.pandora.launcher.ui", (String)"icons/enable/term_sbook.gif"));
        this.stopItem.setEnabled(!this.runItem.isEnabled());
        this.stopItem.addSelectionListener((SelectionListener)this);
        menu.setVisible(true);
        parent.setMenu(menu);
    }

    public Mobile getMobile() {
        return this.mobile;
    }

    public void setMobile(Mobile mobile) {
        this.mobile = mobile;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.runItem) {
            this.runDevice();
        } else if (e.getSource() == this.stopItem) {
            this.stopRunning();
        }
    }

    private void stopRunning() {
        DefaultMobileManager.getInstance().stoped(this.project, this.mobile);
    }

    private void runDevice() {
        this.project = ProjectUtils.getCurrentProject();
        if (this.project == null) {
            return;
        }
        DefaultMobileManager.setCurrentMobile((Mobile)this.mobile);
        HMobileDeviceLauncher.launch((IProject)this.project, (String)"run");
    }

    public void updateStatus(final int status) {
        this.status = status;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MobileMenuAction.this.runItem != null && MobileMenuAction.this.stopItem != null && !MobileMenuAction.this.runItem.isDisposed() && !MobileMenuAction.this.stopItem.isDisposed()) {
                    MobileMenuAction.this.runItem.setEnabled(status == -1);
                    MobileMenuAction.this.stopItem.setEnabled(!MobileMenuAction.this.runItem.isEnabled());
                }
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void running(IProject project, Mobile mobile) {
        if (mobile != null && this.mobile.getUuid().equals(mobile.getUuid())) {
            this.updateStatus(1);
        }
    }

    public void stoped(IProject project, Mobile mobile) {
        if (mobile != null && this.mobile.getUuid().equals(mobile.getUuid())) {
            this.updateStatus(-1);
        }
    }
}

