/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui;

import com.pandora.core.Platform;
import com.pandora.core.log.HBLog;
import com.pandora.core.ui.model.IProjectSelectionDialogModel;
import com.pandora.core.utils.HExplorerUtils;
import com.pandora.core.utils.HUIUtils;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.MobileEventAdapter;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.ui.LauncherActivator;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public class DeviceManager
extends MobileEventAdapter
implements IMobileListener,
SelectionListener {
    private static final String IS_RUNNING = "true";
    private static final String NO_RUNNING = "false";
    private static final String MOBILE_KEY = "MOBILE";
    private static final String PROJECT_KEY = "PROJECT";
    private static final String MODEL_KEY = "MODEL";
    private static String keyBinding;
    private IProject project;

    public DeviceManager() {
        this.initKeyBinding();
    }

    public void initKeyBinding() {
        ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
        if (callback != null && StringUtil.isBlank((String)(keyBinding = callback.getAcceleratorText("com.aptana.ui.run.browser")))) {
            keyBinding = "";
        }
    }

    public void initAndroidDevices(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (!item.isDisposed()) {
                item.dispose();
            }
            ++n2;
        }
        this.project = ProjectUtils.getCurrentProject();
        try {
            String pName = "";
            if (this.project != null && this.project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                pName = " - [" + this.project.getName() + "]";
            }
            if (LauncherCoreActivator.getMachineList((Platform)Platform.ANDROID).isEmpty()) {
                MenuItem item = new MenuItem(menu, 64);
                item.setText("\u5f53\u524d\u6ca1\u6709Android\u624b\u673a\u8fde\u63a5\u3010\u8bf7\u7528USB\u8fde\u63a5\u624b\u673a\u3011");
                item.setEnabled(false);
            } else {
                List mobiles = LauncherCoreActivator.getMobileList();
                for (Mobile mobile : mobiles) {
                    if (mobile == null) continue;
                    String type = "\u8bbe\u5907";
                    if (mobile.getPlatform() != Platform.ANDROID) continue;
                    MenuItem item = new MenuItem(menu, 64);
                    item.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)mobile.getIcon()));
                    String isRUnning = mobile.getStatus() == DefaultMobileManager.MobileStatus.RUNNING ? IS_RUNNING : NO_RUNNING;
                    String text = "";
                    String mName = mobile.getName();
                    if (StringUtil.isNotBlank((String)mobile.getModel())) {
                        mName = mobile.getModel();
                    }
                    if (isRUnning.equals(NO_RUNNING)) {
                        text = "\u5728 [" + mName + "] " + type + "\u4e0a\u8fd0\u884c" + pName;
                    } else {
                        IProject p = mobile.getProject();
                        String pName_ = "";
                        pName_ = p != null ? " - [" + p.getName() + "]" : pName;
                        text = "\u505c\u6b62\u5728 [" + mName + "] " + type + "\u4e0a\u8fd0\u884c" + pName_;
                    }
                    item.setText(text);
                    item.setData(MOBILE_KEY, (Object)mobile);
                    item.setData(PROJECT_KEY, (Object)this.project);
                    item.setData(MODEL_KEY, (Object)"Stream");
                    item.addSelectionListener((SelectionListener)this);
                }
            }
        }
        catch (Exception exception) {}
    }

    public void initDevices(Menu menu) {
        this.initKeyBinding();
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (!item.isDisposed()) {
                item.dispose();
            }
            ++n2;
        }
        this.project = ProjectUtils.getCurrentProject();
        try {
            String pName = "";
            if (this.project != null && this.project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                pName = " - [" + this.project.getName() + "]";
            }
            if (LauncherCoreActivator.getMachineList().isEmpty()) {
                MenuItem item = new MenuItem(menu, 64);
                item.setText("\u5f53\u524d\u6ca1\u6709\u624b\u673a\u8fde\u63a5\u3010\u8bf7\u7528USB\u8fde\u63a5\u624b\u673a\u3011");
                item.setEnabled(false);
            } else {
                boolean isAddKeyBinding = false;
                Mobile preMobile = DefaultMobileManager.getCurrentMobile();
                List mobiles = LauncherCoreActivator.getMobileList();
                boolean hasPre = false;
                if (preMobile != null) {
                    if (mobiles.contains(preMobile)) {
                        hasPre = true;
                    } else {
                        DefaultMobileManager.setCurrentMobile(null);
                    }
                }
                for (Mobile mobile : mobiles) {
                    if (mobile == null) continue;
                    String type = "";
                    type = mobile.getPlatform() == Platform.IOS_SIMULATOR ? "\u6a21\u62df\u5668" : "\u8bbe\u5907";
                    MenuItem item = new MenuItem(menu, 64);
                    item.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)mobile.getIcon()));
                    String isRUnning = mobile.getStatus() == DefaultMobileManager.MobileStatus.RUNNING ? IS_RUNNING : NO_RUNNING;
                    String text = "";
                    String mName = mobile.getName();
                    if (StringUtil.isNotBlank((String)mobile.getModel())) {
                        mName = mobile.getModel();
                    }
                    if (isRUnning.equals(NO_RUNNING)) {
                        text = "\u5728 [" + mName + "] " + type + "\u4e0a\u8fd0\u884c" + pName;
                    } else {
                        IProject p = mobile.getProject();
                        String pName_ = "";
                        pName_ = p != null ? " - [" + p.getName() + "]" : pName;
                        text = "\u505c\u6b62\u5728 [" + mName + "] " + type + "\u4e0a\u8fd0\u884c" + pName_;
                    }
                    if (!hasPre) {
                        if (!isAddKeyBinding) {
                            text = String.valueOf(text) + "\t" + keyBinding;
                            isAddKeyBinding = true;
                        }
                    } else if (mobile.equals((Object)preMobile)) {
                        text = String.valueOf(text) + "\t" + keyBinding;
                        isAddKeyBinding = true;
                    }
                    item.setText(text);
                    item.setData(MOBILE_KEY, (Object)mobile);
                    item.setData(PROJECT_KEY, (Object)this.project);
                    item.addSelectionListener((SelectionListener)this);
                }
                List simulators = LauncherCoreActivator.getSimulatorList();
                if (simulators.size() > 0) {
                    MenuItem subitem = new MenuItem(menu, 64);
                    subitem.setText("iOS \u6a21\u62df\u5668\u8fd0\u884c");
                    subitem.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)"/icons/ios_sim.png"));
                    Menu subMenu = new Menu(subitem);
                    for (Mobile mobile : simulators) {
                        MenuItem item = new MenuItem(subMenu, 64);
                        item.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)mobile.getIcon()));
                        String text = "";
                        String mName = mobile.getName();
                        if (StringUtil.isNotBlank((String)mobile.getModel())) {
                            mName = mobile.getModel();
                        }
                        text = "[" + mName + "] " + pName;
                        item.setText(text);
                        item.setData(MOBILE_KEY, (Object)mobile);
                        item.setData(PROJECT_KEY, (Object)this.project);
                        item.addSelectionListener((SelectionListener)this);
                    }
                    subitem.setMenu(subMenu);
                }
            }
            new MenuItem(menu, 2);
            MenuItem itemfaq = new MenuItem(menu, 64);
            itemfaq.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)"icons/help.png"));
            itemfaq.setText("\u771f\u673a\u8fd0\u884c\u5e38\u89c1\u6545\u969c\u6392\u9664\u6307\u5357");
            itemfaq.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Desktop desk = Desktop.getDesktop();
                    try {
                        desk.browse(URI.create("http://ask.dcloud.net.cn/article/97"));
                    }
                    catch (IOException e1) {
                        HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e1);
                    }
                }
            });
            MenuItem itemEmulator = new MenuItem(menu, 64);
            itemEmulator.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)"icons/help.png"));
            itemEmulator.setText("\u5982\u4f55\u5b89\u88c5\u914d\u7f6e\u624b\u673a\u6a21\u62df\u5668");
            itemEmulator.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Desktop desk = Desktop.getDesktop();
                    try {
                        desk.browse(URI.create("http://ask.dcloud.net.cn/article/151"));
                    }
                    catch (IOException e1) {
                        HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e1);
                    }
                }
            });
            MenuItem itemAndroid = new MenuItem(menu, 64);
            itemAndroid.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)"icons/help.png"));
            itemAndroid.setText("\u5982\u4f55\u4f7f\u7528Chrome\u63a7\u5236\u53f0\u8c03\u8bd5Android\u5e94\u7528");
            itemAndroid.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Desktop desk = Desktop.getDesktop();
                    try {
                        desk.browse(URI.create("http://ask.dcloud.net.cn/article/69"));
                    }
                    catch (IOException e1) {
                        HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e1);
                    }
                }
            });
            MenuItem itemiOS = new MenuItem(menu, 64);
            itemiOS.setImage(ResourceManager.getPluginImage((String)LauncherCoreActivator.PLUGIN_ID, (String)"icons/help.png"));
            itemiOS.setText("\u5982\u4f55\u4f7f\u7528Safari\u63a7\u5236\u53f0\u8c03\u8bd5iOS\u5e94\u7528");
            itemiOS.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Desktop desk = Desktop.getDesktop();
                    try {
                        desk.browse(URI.create("http://ask.dcloud.net.cn/article/143"));
                    }
                    catch (IOException e1) {
                        HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e1);
                    }
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        MenuItem selectedItem;
        Object mobile;
        Object object = e.getSource();
        if (object != null && object instanceof MenuItem && (mobile = (selectedItem = (MenuItem)object).getData(MOBILE_KEY)) != null && mobile instanceof Mobile) {
            String isRunning;
            Mobile m = (Mobile)mobile;
            if ("Stream".equals(selectedItem.getData(MODEL_KEY))) {
                m.setCached(false);
            } else {
                m.setCached(true);
            }
            String string = isRunning = m.getStatus() == DefaultMobileManager.MobileStatus.RUNNING ? IS_RUNNING : NO_RUNNING;
            if (StringUtil.isNotBlank((String)isRunning) && isRunning.equals(IS_RUNNING)) {
                this.stopRunning(m);
            } else {
                block8: {
                    Object project = selectedItem.getData(PROJECT_KEY);
                    try {
                        if (project != null && project instanceof IProject && ((IProject)project).hasNature("com.pandora.projects.ui.MKeyNature")) break block8;
                        IProject res = this.selectProject(selectedItem.getDisplay().getActiveShell());
                        if (res != null && res.hasNature("com.pandora.projects.ui.MKeyNature")) {
                            this.project = res;
                            break block8;
                        }
                        return;
                    }
                    catch (CoreException coreException) {}
                }
                this.runDevice(m);
            }
        }
    }

    public IProject selectProject(Shell shell) throws CoreException {
        HashSet projectsWithSpecifics = new HashSet();
        HashSet<String> natureIdSet = new HashSet<String>();
        natureIdSet.add("com.pandora.projects.ui.MKeyNature");
        IProjectSelectionDialogModel dialog = HUIUtils.getProjectSelectionDialog((Shell)shell, projectsWithSpecifics, natureIdSet);
        ILabelProvider labelProvider = HExplorerUtils.getLabelProvider();
        if (dialog == null || labelProvider == null) {
            MessageBox box = new MessageBox(shell, 8);
            box.setMessage("\u8bf7\u9009\u62e9\u4e00\u4e2a\u79fb\u52a8\u5e94\u7528\u9879\u76ee.");
            box.setText("\u8fd0\u884c\u63d0\u793a");
            box.open();
            return null;
        }
        dialog.setMessage("\u6ca1\u6709\u9009\u4e2d\u4efb\u4f55\u79fb\u52a8App\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u79fb\u52a8App\u8fdb\u884c\u771f\u673a\u8fd0\u884c");
        dialog.setLabelProvider(labelProvider);
        dialog.setNeedAddCheckFilter(false);
        if (dialog.open() == 0) {
            IProject res = (IProject)dialog.getFirstResult();
            if (res != null && res.hasNature("com.pandora.projects.ui.MKeyNature")) {
                return res;
            }
            MessageBox box = new MessageBox(shell, 8);
            box.setMessage("\u8bf7\u9009\u62e9\u4e00\u4e2a\u79fb\u52a8\u5e94\u7528\u9879\u76ee.");
            box.setText("\u8fd0\u884c\u63d0\u793a");
            box.open();
            return null;
        }
        return null;
    }

    private void runDevice(Mobile mobile) {
        if (this.project == null) {
            return;
        }
        DefaultMobileManager.setCurrentMobile((Mobile)mobile);
        HMobileDeviceLauncher.launch((IProject)this.project, (String)"run");
    }

    private void stopRunning(Mobile mobile) {
        IProject p = mobile.getProject();
        DefaultMobileManager.getInstance().stoped(p != null ? p : this.project, mobile);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

