/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.dtd.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.dtd.parsing.DTDSourceScanner;
import com.aptana.editor.dtd.parsing.lexer.DTDTokenType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class DTDScanner
extends Scanner {
    private static final Pattern ENTITY = Pattern.compile("%([^; \\t\\n]+);");
    private DTDParserScanner _sourceScanner = new DTDParserScanner();
    private IDocument _document;
    private Map<String, String> _entities;
    private Stack<DTDParserScanner> _nestedScanners = new Stack();

    protected void createNestedScanner(String text) {
        DTDParserScanner nestedScanner = new DTDParserScanner();
        Document document = new Document(text);
        nestedScanner.setRange((IDocument)document, 0, document.getLength());
        this._nestedScanners.push(nestedScanner);
    }

    protected Symbol createSymbol(Object data) throws Scanner.Exception {
        IDocument document;
        DTDParserScanner scanner;
        if (this._nestedScanners.size() > 0) {
            scanner = this._nestedScanners.peek();
            document = scanner.getDocument();
        } else {
            scanner = this._sourceScanner;
            document = this._document;
        }
        int offset = scanner.getTokenOffset();
        int length = scanner.getTokenLength();
        DTDTokenType type = data == null ? DTDTokenType.EOF : (DTDTokenType)((Object)data);
        try {
            int totalLength = document.getLength();
            if (offset > totalLength) {
                offset = totalLength;
            }
            if (length == -1) {
                length = 0;
            }
            return new Symbol(type.getIndex(), offset, offset + length - 1, (Object)document.get(offset, length));
        }
        catch (BadLocationException e) {
            throw new Scanner.Exception(e.getLocalizedMessage());
        }
    }

    protected IToken getToken() {
        IToken token = null;
        while (this._nestedScanners.size() > 0) {
            int length;
            int end;
            DTDParserScanner nestedScanner = this._nestedScanners.peek();
            token = nestedScanner.nextToken();
            if (token.isWhitespace() || token.getData() != null) break;
            this._nestedScanners.pop();
            token = null;
            if (!Platform.inDevelopmentMode() || (end = nestedScanner.getTokenOffset() + nestedScanner.getTokenLength()) == (length = nestedScanner.getDocument().getLength())) continue;
            System.out.println("end = " + end + ", length = " + length);
            System.out.println(nestedScanner.getDocument().get());
        }
        if (token == null) {
            token = this._sourceScanner.nextToken();
        }
        return token;
    }

    public String getValue(String key) {
        String result = null;
        if (this._entities != null) {
            result = this._entities.get(key);
        }
        return result;
    }

    protected boolean isComment(Object data) {
        return data != null && (DTDTokenType)((Object)data) == DTDTokenType.COMMENT;
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        IToken token = this.getToken();
        Object data = token.getData();
        while (token.isWhitespace() || this.isComment(data)) {
            token = this.getToken();
            data = token.getData();
        }
        Symbol result = this.createSymbol(data);
        if (data == DTDTokenType.STRING) {
            String text = (String)result.value;
            StringBuffer buffer = new StringBuffer();
            Matcher m = ENTITY.matcher(text);
            while (m.find()) {
                String name = m.group(1);
                String newText = this.getValue(name);
                if (newText == null) {
                    newText = name;
                }
                m.appendReplacement(buffer, newText);
            }
            m.appendTail(buffer);
            result = new Symbol(result.getId(), result.getStart(), result.getEnd(), (Object)buffer.toString());
        } else if (data == DTDTokenType.PE_REF) {
            String key = (String)result.value;
            key = key.substring(1, key.length() - 1);
            String text = this.getValue(key);
            this.createNestedScanner(text);
            result = this.nextToken();
        }
        return result;
    }

    public void register(String key, String value) {
        if (this._entities == null) {
            this._entities = new HashMap<String, String>();
        }
        if (!this._entities.containsKey(key)) {
            this._entities.put(key, value);
        }
    }

    public void setSource(IDocument document) {
        this._document = document;
        this._sourceScanner.setRange(document, 0, document.getLength());
        this._nestedScanners.clear();
    }

    public void setSource(String text) {
        this.setSource((IDocument)new Document(text));
    }

    private static class DTDParserScanner
    extends DTDSourceScanner {
        private DTDParserScanner() {
        }

        @Override
        protected IToken createToken(DTDTokenType type) {
            return new Token((Object)type);
        }

        protected IDocument getDocument() {
            return this.fDocument;
        }
    }
}

