/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui.launcher;

import com.aptana.core.logging.IdeLog;
import com.aptana.ruby.debug.ui.RubyDebugUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class RubyApplicationShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            try {
                IAdaptable adapt;
                IStructuredSelection structured = (IStructuredSelection)selection;
                Object first = structured.getFirstElement();
                if (first instanceof IFile) {
                    this.doLaunch((IFile)first, mode);
                } else if (first instanceof IAdaptable && (first = (adapt = (IAdaptable)first).getAdapter(IResource.class)) instanceof IFile) {
                    this.doLaunch((IFile)first, mode);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    protected void doLaunch(IFile rubyElement, String mode) throws CoreException {
        ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(rubyElement, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (String)("Could not retrieve input from editor: " + editor.getTitle()));
            return;
        }
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            try {
                this.doLaunch(file, mode);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(IFile rubyFile, String mode) throws CoreException {
        ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            boolean absoluteFilenamesMatch = config.getAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", "").equals(rubyFile.getLocation().toOSString());
            if (absoluteFilenamesMatch) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createConfiguration(rubyFile);
            }
            case 1: {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
        }
        Status status = new Status(2, RubyDebugUIPlugin.getPluginId(), 0, "Multiple configurations match", null);
        throw new CoreException((IStatus)status);
    }

    protected ILaunchConfiguration createConfiguration(IFile rubyFile) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(rubyFile.getName()));
            wc.setAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", rubyFile.getLocation().toOSString());
            wc.setAttribute("com.aptana.ruby.debug.ATTR_WORKING_DIR", RubyApplicationShortcut.getDefaultWorkingDirectory(rubyFile));
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "com.aptana.ruby.debug.core.sourceLocator");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            IdeLog.logError((Plugin)RubyDebugUIPlugin.getDefault(), (Throwable)ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("com.aptana.ruby.debug.core.launchConfigurationType");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected static String getDefaultWorkingDirectory(IFile file) {
        if (file.getParent() != null && file.getParent().exists()) {
            return file.getParent().getLocation().toOSString();
        }
        if (file.getProject() != null && file.getProject().exists()) {
            return file.getProject().getLocation().toOSString();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }
}

