/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.build.util;

import java.util.HashMap;

public class BuildHelper {
    private static HashMap<String, Integer> SLEEP_TIME = new HashMap();
    private static HashMap<String, Integer> SLEEP_COUNT = new HashMap();
    public static final String PARSER_TYPE = "PARSER_TYPE";
    public static final int PARSER_SLEEP_time = 2;
    public static final int PARSER_LOOP_COUNT = 5000;
    public static final String HTML_INDEX_TYPE = "HTML_INDEX_TYPE";
    public static final int HTML_INDEX_SLEEP_time = 1;
    public static final int HTML_INDEX_LOOP_COUNT = 25;
    public static final String CSS_INDEX_TYPE = "CSS_INDEX_TYPE";
    public static final int CSS_INDEX_SLEEP_time = 2;
    public static final int CSS_INDEX_LOOP_COUNT = 100;
    public static final String JS_INDEX_TYPE = "JS_INDEX_TYPE";
    public static final int JS_INDEX_SLEEP_time = 1;
    public static final int JS_INDEX_LOOP_COUNT = 200;
    public static final String BUILD_FILE_TYPE = "BUILD_FILE_TYPE";
    public static final int BUILD_FILE_SLEEP_time = 10;
    public static final int BUILD_FILE_LOOP_COUNT = 1;
    public static final String JS_SCOPE_TYPE = "JS_SCOPE_TYPE";
    public static final int JS_SCOPE_SLEEP_time = 1;
    public static final int JS_SCOPE_LOOP_COUNT = 1;
    public static final String JS_SYMBOL_LOOP_TYPE = "JS_SYMBOL_LOOP_TYPE";
    public static final int JS_SYMBOL_LOOP_SLEEP_time = 2;
    public static final int JS_SYMBOL_LOOP_COUNT = 200;
    public static final String JS_NODE_LOOP_TYPE = "JS_NODE_LOOP_TYPE";
    public static final int JS_NODE_LOOP_SLEEP_time = 1;
    public static final int JS_NODE_LOOP_COUNT = 200;
    public static final String TASK_TYPE = "TASK_TYPE";
    public static final int TASK_SLEEP_time = 2;
    public static final int TASK_LOOP_COUNT = 100;
    public static final String PHP_INDEX_TYPE = "PHP_INDEX_TYPE";
    public static final int PHP_INDEX_SLEEP_time = 1;
    public static final int PHP_INDEX_LOOP_COUNT = 100;
    private static ThreadLocal<Long> timer;

    static {
        SLEEP_TIME.put(BUILD_FILE_TYPE, 10);
        SLEEP_TIME.put(CSS_INDEX_TYPE, 2);
        SLEEP_TIME.put(HTML_INDEX_TYPE, 1);
        SLEEP_TIME.put(JS_INDEX_TYPE, 1);
        SLEEP_TIME.put(JS_SCOPE_TYPE, 1);
        SLEEP_TIME.put(JS_SYMBOL_LOOP_TYPE, 2);
        SLEEP_TIME.put(PARSER_TYPE, 2);
        SLEEP_TIME.put(JS_NODE_LOOP_TYPE, 1);
        SLEEP_TIME.put(TASK_TYPE, 2);
        SLEEP_TIME.put(PHP_INDEX_TYPE, 1);
        SLEEP_COUNT.put(BUILD_FILE_TYPE, 1);
        SLEEP_COUNT.put(CSS_INDEX_TYPE, 100);
        SLEEP_COUNT.put(HTML_INDEX_TYPE, 25);
        SLEEP_COUNT.put(JS_INDEX_TYPE, 200);
        SLEEP_COUNT.put(JS_SCOPE_TYPE, 1);
        SLEEP_COUNT.put(JS_SYMBOL_LOOP_TYPE, 200);
        SLEEP_COUNT.put(PARSER_TYPE, 5000);
        SLEEP_COUNT.put(JS_NODE_LOOP_TYPE, 200);
        SLEEP_COUNT.put(TASK_TYPE, 100);
        SLEEP_COUNT.put(PHP_INDEX_TYPE, 100);
        timer = new ThreadLocal();
    }

    public static void sleep(String type) {
        if (!BuildHelper.checkType(type)) {
            return;
        }
        try {
            Thread.sleep(SLEEP_TIME.get(type).intValue());
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void sleepLoop(String type, int count) {
        if (!BuildHelper.checkType(type)) {
            return;
        }
        if (count % SLEEP_COUNT.get(type) == 0) {
            try {
                Thread.sleep(SLEEP_TIME.get(type).intValue());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean checkType(String type) {
        if (type == null || type == "") {
            return false;
        }
        return SLEEP_TIME.containsKey(type);
    }

    public static void resetTimeGap() {
        timer.set(null);
    }

    public static void waitByTimeGap() {
        Long preTime = timer.get();
        if (preTime != null) {
            long nowTime = System.currentTimeMillis();
            if (nowTime - preTime >= 1L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                timer.set(System.currentTimeMillis());
            }
        } else {
            timer.set(System.currentTimeMillis());
        }
    }
}

