/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec.ast;

import beaver.Symbol;
import beaver.spec.ast.Node;
import beaver.spec.ast.TreeWalker;

public class Rule
extends Node {
    public final Symbol lhs_sym;
    public final Definition[] defs;

    public Rule(Symbol lhs_sym, Definition[] defs) {
        this.lhs_sym = lhs_sym;
        this.defs = defs;
    }

    public String getLHSSymbolName() {
        return (String)this.lhs_sym.value;
    }

    @Override
    public void accept(TreeWalker walker) {
        walker.visit(this);
    }

    public static class Definition
    extends Node {
        public final Element[] elements;
        public final Symbol prec_sym_name;
        public final Symbol code;

        public Definition(Element[] elts, Symbol prec_sym_name, Symbol code) {
            this.elements = elts;
            this.prec_sym_name = prec_sym_name;
            this.code = code;
        }

        public Definition(Element[] elts) {
            this.elements = elts;
            this.prec_sym_name = null;
            this.code = null;
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }

        public String getPrecedenceSymbolName() {
            return (String)this.prec_sym_name.value;
        }

        public String getReduceActionCode() {
            return (String)this.code.value;
        }

        public static class Element
        extends Node {
            public final Symbol sym_name;
            public final Symbol alias;
            public final Symbol ebnf_sym;

            public Element(Symbol sym_name, Symbol alias, Symbol ebnf_sym) {
                this.sym_name = sym_name;
                this.alias = alias;
                this.ebnf_sym = ebnf_sym;
            }

            @Override
            public void accept(TreeWalker walker) {
                walker.visit(this);
            }

            public String getName() {
                return (String)this.sym_name.value;
            }

            public String getAlias() {
                return (String)this.alias.value;
            }

            public char getExtUseMark() {
                return this.ebnf_sym.value == null ? (char)' ' : ((String)this.ebnf_sym.value).charAt(0);
            }
        }
    }
}

