/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec.ast;

import beaver.Symbol;
import beaver.spec.ast.Node;
import beaver.spec.ast.TreeWalker;

public abstract class Declaration
extends Node {

    public static class ClassCode
    extends CodeContainer {
        public ClassCode(Symbol code) {
            super(code);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class ClassName
    extends NameContainer {
        public ClassName(Symbol name) {
            super(name);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static abstract class CodeContainer
    extends Declaration {
        public final Symbol code;

        protected CodeContainer(Symbol code) {
            this.code = code;
        }

        public String getCode() {
            return (String)this.code.value;
        }
    }

    public static class ConstructorCode
    extends CodeContainer {
        public ConstructorCode(Symbol code) {
            super(code);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class Error
    extends Declaration {
        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class Goal
    extends NameContainer {
        public Goal(Symbol name) {
            super(name);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class Header
    extends CodeContainer {
        public Header(Symbol code) {
            super(code);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class Implements
    extends SymbolsContainer {
        public Implements(Symbol[] names) {
            super(names);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class Imports
    extends SymbolsContainer {
        public Imports(Symbol[] symbols) {
            super(symbols);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class LeftAssoc
    extends SymbolsContainer {
        public LeftAssoc(Symbol[] symbols) {
            super(symbols);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class ListType
    extends NameContainer {
        public ListType(Symbol name) {
            super(name);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static abstract class NameContainer
    extends Declaration {
        public final Symbol name;

        protected NameContainer(Symbol name) {
            this.name = name;
        }

        public String getName() {
            return (String)this.name.value;
        }
    }

    public static class NonAssoc
    extends SymbolsContainer {
        public NonAssoc(Symbol[] symbols) {
            super(symbols);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class PackageName
    extends NameContainer {
        public PackageName(Symbol name) {
            super(name);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class RightAssoc
    extends SymbolsContainer {
        public RightAssoc(Symbol[] symbols) {
            super(symbols);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static abstract class SymbolsContainer
    extends Declaration {
        public final Symbol[] symbols;

        protected SymbolsContainer(Symbol[] symbols) {
            this.symbols = symbols;
        }
    }

    public static class Terminals
    extends SymbolsContainer {
        public Terminals(Symbol[] tokens) {
            super(tokens);
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }

    public static class TypeOf
    extends SymbolsContainer {
        public final Symbol type;

        public TypeOf(Symbol[] symbols, Symbol type) {
            super(symbols);
            this.type = type;
        }

        public String getTypeName() {
            return this.type == null ? null : (String)this.type.value;
        }

        @Override
        public void accept(TreeWalker walker) {
            walker.visit(this);
        }
    }
}

