/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.internal;

import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class DeleteResourceShortcutListener
implements IResourceChangeListener {
    private static final String CATEGORY_ID = "com.aptana.ide.core.io.projectShortcuts";

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        switch (delta.getKind()) {
            case 2: {
                break;
            }
            case 4: {
                IConnectionPoint[] projectShortcuts;
                ArrayList<IConnectionPoint> deleted = new ArrayList<IConnectionPoint>();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IConnectionPointManager manager = CoreIOPlugin.getConnectionPointManager();
                IConnectionPoint[] iConnectionPointArray = projectShortcuts = manager.getConnectionPointCategory(CATEGORY_ID).getConnectionPoints();
                int n = projectShortcuts.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionPoint shortcut = iConnectionPointArray[n2];
                    WorkspaceConnectionPoint connectionPoint = (WorkspaceConnectionPoint)shortcut;
                    IResourceDelta d = delta.findMember(connectionPoint.getPath());
                    if (d != null && d.getKind() == 2) {
                        if (d.getMovedToPath() == null) {
                            IResource resource = d.getResource();
                            if (resource instanceof IProject || !resource.getProject().exists() || resource.getProject().isOpen()) {
                                deleted.add(shortcut);
                            }
                        } else {
                            IPath newPath = d.getMovedToPath();
                            Object newContainer = d.getResource() instanceof IProject ? root.getProject(newPath.toString()) : root.getFolder(newPath);
                            connectionPoint.setResource((IContainer)newContainer);
                            connectionPoint.setName(newContainer.getName());
                        }
                    }
                    ++n2;
                }
                for (IConnectionPoint projectShortcut : deleted) {
                    manager.removeConnectionPoint(projectShortcut);
                }
                break;
            }
        }
    }
}

