/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.writer;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.writer.CSSWriterSettings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWriter {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    private final CSSWriterSettings m_aSettings;
    private boolean m_bWriteHeaderText;
    private String m_sHeaderText = "THIS FILE IS GENERATED - DO NOT EDIT";
    private boolean m_bWriteFooterText;
    private String m_sFooterText;
    private String m_sContentCharset;

    public CSSWriter(@Nonnull ECSSVersion eVersion) {
        this(eVersion, false);
    }

    public CSSWriter(@Nonnull ECSSVersion eVersion, boolean bOptimizedOutput) {
        this(new CSSWriterSettings(eVersion, bOptimizedOutput));
    }

    public CSSWriter(@Nonnull CSSWriterSettings aSettings) {
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        this.m_aSettings = aSettings;
        this.m_bWriteHeaderText = !aSettings.isOptimizedOutput();
        this.m_bWriteFooterText = !aSettings.isOptimizedOutput();
    }

    public boolean isWriteHeaderText() {
        return this.m_bWriteHeaderText;
    }

    @Nonnull
    public CSSWriter setWriteHeaderText(boolean bWriteHeaderText) {
        this.m_bWriteHeaderText = bWriteHeaderText;
        return this;
    }

    @Nullable
    public String getHeaderText() {
        return this.m_sHeaderText;
    }

    @Nonnull
    public CSSWriter setHeaderText(@Nullable String sHeaderText) {
        this.m_sHeaderText = sHeaderText;
        return this;
    }

    public boolean isWriteFooterText() {
        return this.m_bWriteFooterText;
    }

    @Nonnull
    public CSSWriter setWriteFooterText(boolean bWriteFooterText) {
        this.m_bWriteFooterText = bWriteFooterText;
        return this;
    }

    @Nullable
    public String getFooterText() {
        return this.m_sFooterText;
    }

    @Nonnull
    public CSSWriter setFooterText(@Nullable String sFooterText) {
        this.m_sFooterText = sFooterText;
        return this;
    }

    @Nullable
    public String getContentCharset() {
        return this.m_sContentCharset;
    }

    @Nonnull
    public CSSWriter setContentCharset(@Nullable String sContentCharset) {
        this.m_sContentCharset = sContentCharset;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(reason="Design")
    public CSSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    public void writeCSS(@Nonnull CascadingStyleSheet aCSS, @Nonnull @WillClose Writer aWriter) throws IOException {
        ValueEnforcer.notNull((Object)aCSS, (String)"CSS");
        ValueEnforcer.notNull((Object)aWriter, (String)"Writer");
        try {
            List<CSSNamespaceRule> aNamespaceRules;
            boolean bOptimizedOutput = this.m_aSettings.isOptimizedOutput();
            if (this.m_bWriteHeaderText && StringHelper.hasText((String)this.m_sHeaderText)) {
                aWriter.write("/*\n");
                for (String sLine : StringHelper.getExploded((String)"\n", (String)this.m_sHeaderText)) {
                    aWriter.write(" * " + sLine + "\n");
                }
                aWriter.write(" */\n");
            }
            if (StringHelper.hasText((String)this.m_sContentCharset)) {
                aWriter.write("@charset \"" + this.m_sContentCharset + "\";");
                if (!bOptimizedOutput) {
                    aWriter.write(10);
                }
            }
            int nRulesEmitted = 0;
            List<CSSImportRule> aImportRules = aCSS.getAllImportRules();
            if (!aImportRules.isEmpty()) {
                for (CSSImportRule aImportRule : aImportRules) {
                    aWriter.write(aImportRule.getAsCSSString(this.m_aSettings, 0));
                    ++nRulesEmitted;
                }
            }
            if (!(aNamespaceRules = aCSS.getAllNamespaceRules()).isEmpty()) {
                for (CSSNamespaceRule aNamespaceRule : aNamespaceRules) {
                    aWriter.write(aNamespaceRule.getAsCSSString(this.m_aSettings, 0));
                    ++nRulesEmitted;
                }
            }
            for (ICSSTopLevelRule aRule : aCSS.getAllRules()) {
                String sRuleCSS = aRule.getAsCSSString(this.m_aSettings, 0);
                if (!StringHelper.hasText((String)sRuleCSS)) continue;
                if (!bOptimizedOutput && nRulesEmitted > 0) {
                    aWriter.write(10);
                }
                aWriter.write(sRuleCSS);
                ++nRulesEmitted;
            }
            if (this.m_bWriteFooterText && StringHelper.hasText((String)this.m_sFooterText)) {
                aWriter.write("/*\n");
                for (String sLine : StringHelper.getExploded((String)"\n", (String)this.m_sFooterText)) {
                    aWriter.write(" * " + sLine + "\n");
                }
                aWriter.write(" */\n");
            }
        }
        finally {
            StreamUtils.close((Closeable)aWriter);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CascadingStyleSheet aCSS) {
        NonBlockingStringWriter aSW = new NonBlockingStringWriter();
        try {
            this.writeCSS(aCSS, (Writer)aSW);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Totally unexpected", ex);
        }
        return aSW.getAsString();
    }

    public void writeCSS(@Nonnull ICSSWriteable aCSS, @Nonnull @WillClose Writer aWriter) throws IOException {
        ValueEnforcer.notNull((Object)aCSS, (String)"CSS");
        ValueEnforcer.notNull((Object)aWriter, (String)"Writer");
        try {
            aWriter.write(aCSS.getAsCSSString(this.m_aSettings, 0));
        }
        finally {
            StreamUtils.close((Closeable)aWriter);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull ICSSWriteable aCSS) {
        NonBlockingStringWriter aSW = new NonBlockingStringWriter();
        try {
            this.writeCSS(aCSS, (Writer)aSW);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Totally unexpected", ex);
        }
        return aSW.getAsString();
    }
}

