/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.writer;

import com.phloc.commons.ValueEnforcer;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.reader.CSSReader;
import com.phloc.css.writer.CSSWriter;
import com.phloc.css.writer.CSSWriterSettings;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSCompressor.class);
    private static final CSSCompressor s_aInstance = new CSSCompressor();

    private CSSCompressor() {
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String sOriginalCSS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSCompressor.getCompressedCSS(sOriginalCSS, aCharset, eCSSVersion, false);
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String sOriginalCSS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eCSSVersion, boolean bRemoveUnnecessaryCode) {
        CSSWriterSettings aSettings = new CSSWriterSettings(eCSSVersion, true);
        aSettings.setRemoveUnnecessaryCode(bRemoveUnnecessaryCode);
        return CSSCompressor.getRewrittenCSS(sOriginalCSS, aCharset, aSettings);
    }

    @Nonnull
    @Deprecated
    public static String getRewrittenCSS(@Nonnull String sOriginalCSS, @Nonnull Charset aCharset, @Nonnull CSSWriterSettings aSettings) {
        return CSSCompressor.getRewrittenCSS(sOriginalCSS, aSettings);
    }

    @Nonnull
    public static String getRewrittenCSS(@Nonnull String sOriginalCSS, @Nonnull CSSWriterSettings aSettings) {
        ValueEnforcer.notNull((Object)sOriginalCSS, (String)"OriginalCSS");
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        CascadingStyleSheet aCSS = CSSReader.readFromString(sOriginalCSS, aSettings.getVersion());
        if (aCSS != null) {
            try {
                return new CSSWriter(aSettings).getCSSAsString(aCSS);
            }
            catch (Exception ex) {
                s_aLogger.warn("Failed to write optimized CSS!", (Throwable)ex);
            }
        }
        return sOriginalCSS;
    }
}

