/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.ISimpleURL;
import com.phloc.css.parser.ParseUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSURLHelper {
    public static final boolean DEFAULT_QUOTE_URLS = false;
    private static final CSSURLHelper s_aInstance = new CSSURLHelper();

    private CSSURLHelper() {
    }

    public static boolean isURLValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        if (StringHelper.hasNoText((String)sRealValue)) {
            return false;
        }
        if (sRealValue.equals("none")) {
            return true;
        }
        return sRealValue.length() > 5 && sRealValue.startsWith("url(") && sRealValue.endsWith(")");
    }

    @Nullable
    public static String getURLValue(@Nullable String sValue) {
        if (CSSURLHelper.isURLValue(sValue)) {
            return ParseUtils.trimUrl(sValue);
        }
        return null;
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull ISimpleURL aURL, boolean bQuoteURL) {
        ValueEnforcer.notNull((Object)aURL, (String)"URL");
        return CSSURLHelper.getAsCSSURL(aURL.getAsString(), bQuoteURL);
    }

    public static boolean isValidCSSURLChar(char c) {
        return c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c >= '*' && c <= '[' || c >= ']' && c <= '~' || c >= '\u0080' && c <= '\uffff';
    }

    public static boolean isCSSURLRequiringQuotes(@Nonnull String sURL) {
        ValueEnforcer.notNull((Object)sURL, (String)"URL");
        char[] cArray = sURL.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!CSSURLHelper.isValidCSSURLChar(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Nonnull
    @Nonempty
    public static String getEscapedCSSURL(@Nonnull String sURL, char cQuoteChar) {
        ValueEnforcer.notNull((Object)sURL, (String)"URL");
        if (sURL.indexOf(cQuoteChar) < 0 && sURL.indexOf(92) < 0) {
            return sURL;
        }
        StringBuilder aSB = new StringBuilder(sURL.length() * 2);
        char[] cArray = sURL.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == cQuoteChar || c == '\\') {
                aSB.append('\\');
            }
            aSB.append(c);
            ++n2;
        }
        return aSB.toString();
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull @Nonempty String sURL, boolean bForceQuoteURL) {
        boolean bAreQuotesRequired;
        ValueEnforcer.notEmpty((CharSequence)sURL, (String)"URL");
        StringBuilder aSB = new StringBuilder("url(");
        boolean bl = bAreQuotesRequired = bForceQuoteURL || CSSURLHelper.isCSSURLRequiringQuotes(sURL);
        if (bAreQuotesRequired) {
            int nIndexSingleQuote = sURL.indexOf(39);
            int nIndexDoubleQuote = sURL.indexOf(34);
            char cQuote = nIndexSingleQuote >= 0 && nIndexDoubleQuote < 0 ? (char)'\"' : '\'';
            aSB.append(cQuote).append(CSSURLHelper.getEscapedCSSURL(sURL, cQuote)).append(cQuote);
        } else {
            aSB.append(sURL);
        }
        return aSB.append(")").toString();
    }
}

