/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.decl.CSSRect;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSRectHelper {
    @RegEx
    private static final String PATTERN_PART_VALUE = "([0-9]+(?:[a-zA-Z]+|%)?|auto)";
    @RegEx
    private static final String PATTERN_CURRENT_SYNTAX = "^rect\\s*\\(\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*,\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*,\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*,\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*\\)$";
    @RegEx
    private static final String PATTERN_OLD_SYNTAX = "^rect\\s*\\(\\s*([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s+([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s+([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s+([0-9]+(?:[a-zA-Z]+|%)?|auto)\\s*\\)$";
    private static final CSSRectHelper s_aInstance = new CSSRectHelper();

    private CSSRectHelper() {
    }

    public static boolean isRectValue(@Nullable String sCSSValue) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        if (StringHelper.hasText((String)sRealValue)) {
            if (RegExHelper.stringMatchesPattern((String)PATTERN_CURRENT_SYNTAX, (String)sRealValue)) {
                return true;
            }
            if (RegExHelper.stringMatchesPattern((String)PATTERN_OLD_SYNTAX, (String)sRealValue)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static String[] getRectValues(@Nullable String sCSSValue) {
        String[] ret = null;
        String sRealValue = StringHelper.trim((String)sCSSValue);
        if (StringHelper.hasText((String)sRealValue) && (ret = RegExHelper.getAllMatchingGroupValues((String)PATTERN_CURRENT_SYNTAX, (String)sRealValue)) == null) {
            ret = RegExHelper.getAllMatchingGroupValues((String)PATTERN_OLD_SYNTAX, (String)sRealValue);
        }
        return ret;
    }

    @Nullable
    public static CSSRect getAsRect(@Nullable String sCSSValue) {
        String[] aValues = CSSRectHelper.getRectValues(sCSSValue);
        return aValues == null ? null : new CSSRect(aValues[0], aValues[1], aValues[2], aValues[3]);
    }
}

