/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.compare.ComparatorStringLongestFirst;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.css.ECSSUnit;
import com.phloc.css.propertyvalue.CSSSimpleValueWithUnit;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSNumberHelper {
    private static final Map<String, ECSSUnit> s_aNameToUnitMap;
    private static final CSSNumberHelper s_aInstance;

    static {
        HashMap<String, ECSSUnit> aNameToUnitMap = new HashMap<String, ECSSUnit>();
        ECSSUnit[] eCSSUnitArray = ECSSUnit.values();
        int n = eCSSUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ECSSUnit eUnit = eCSSUnitArray[n2];
            aNameToUnitMap.put(eUnit.getName(), eUnit);
            ++n2;
        }
        s_aNameToUnitMap = ContainerHelper.getSortedByKey(aNameToUnitMap, (Comparator)new ComparatorStringLongestFirst());
        s_aInstance = new CSSNumberHelper();
    }

    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String sCSSValue) {
        ValueEnforcer.notNull((Object)sCSSValue, (String)"CSSValue");
        for (Map.Entry<String, ECSSUnit> aEntry : s_aNameToUnitMap.entrySet()) {
            if (!sCSSValue.endsWith(aEntry.getKey())) continue;
            return aEntry.getValue();
        }
        return null;
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String sCSSValue) {
        ECSSUnit eUnit = CSSNumberHelper.getMatchingUnitInclPercentage(sCSSValue);
        return eUnit == null || eUnit == ECSSUnit.PERCENTAGE ? null : eUnit;
    }

    public static boolean isNumberValue(@Nullable String sCSSValue) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        return StringHelper.hasText((String)sRealValue) && StringParser.isDouble((String)sRealValue);
    }

    public static boolean isValueWithUnit(@Nullable String sCSSValue) {
        return CSSNumberHelper.getValueWithUnit(sCSSValue) != null;
    }

    public static boolean isValueWithUnit(@Nullable String sCSSValue, boolean bWithPerc) {
        return CSSNumberHelper.getValueWithUnit(sCSSValue, bWithPerc) != null;
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String sCSSValue) {
        return CSSNumberHelper.getValueWithUnit(sCSSValue, true);
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String sCSSValue, boolean bWithPerc) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        if (StringHelper.hasText((String)sRealValue)) {
            BigDecimal aValue;
            ECSSUnit eUnit;
            if (sRealValue.equals("0")) {
                return new CSSSimpleValueWithUnit(BigDecimal.ZERO, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit = eUnit = bWithPerc ? CSSNumberHelper.getMatchingUnitInclPercentage(sRealValue) : CSSNumberHelper.getMatchingUnitExclPercentage(sRealValue);
            if (eUnit != null && (aValue = StringParser.parseBigDecimal((String)(sRealValue = sRealValue.substring(0, sRealValue.length() - eUnit.getName().length()).trim()))) != null) {
                return new CSSSimpleValueWithUnit(aValue, eUnit);
            }
        }
        return null;
    }
}

