/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.base64.Base64Helper;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.mime.CMimeType;
import com.phloc.commons.mime.EMimeQuoting;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.mime.MimeType;
import com.phloc.commons.mime.MimeTypeParser;
import com.phloc.commons.mime.MimeTypeUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.utils.CSSDataURL;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSDataURLHelper {
    public static final Charset DEFAULT_CHARSET = CCharset.CHARSET_US_ASCII_OBJ;
    public static final IMimeType DEFAULT_MIME_TYPE = new MimeType(CMimeType.TEXT_PLAIN).addParameter("charset", DEFAULT_CHARSET.name());
    public static final String PREFIX_DATA_URL = "data:";
    public static final String BASE64_MARKER = ";base64";
    public static final char SEPARATOR_CONTENT = ',';
    public static final EMimeQuoting MIME_QUOTING = EMimeQuoting.URL_ESCAPE;
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSDataURLHelper.class);
    private static final CSSDataURLHelper s_aInstance = new CSSDataURLHelper();

    private CSSDataURLHelper() {
    }

    public static boolean isDataURL(@Nullable String sURL) {
        if (sURL == null) {
            return false;
        }
        String sRealURL = sURL.trim();
        return sRealURL.startsWith(PREFIX_DATA_URL);
    }

    @Nullable
    public static CSSDataURL parseDataURL(@Nullable String sDataURL) {
        IMimeType aMimeType;
        int nMIMETypeEnd;
        boolean bBase64EncodingUsed;
        int nIndexComma;
        String sRest;
        block18: {
            if (!CSSDataURLHelper.isDataURL(sDataURL)) {
                return null;
            }
            sRest = StringHelper.trimStart((String)sDataURL.trim(), (String)PREFIX_DATA_URL);
            if (StringHelper.hasNoText((String)sRest)) {
                return new CSSDataURL();
            }
            nIndexComma = sRest.indexOf(44);
            int nIndexBase64 = sRest.indexOf(BASE64_MARKER);
            bBase64EncodingUsed = false;
            if (nIndexBase64 >= 0) {
                if (nIndexBase64 < nIndexComma || nIndexComma < 0) {
                    do {
                        int nIndexEquals;
                        if ((nIndexEquals = sRest.indexOf(61, nIndexBase64)) >= 0 && nIndexEquals <= nIndexComma && nIndexComma >= 0) continue;
                        nMIMETypeEnd = nIndexBase64;
                        bBase64EncodingUsed = true;
                        break block18;
                    } while ((nIndexBase64 = sRest.indexOf(BASE64_MARKER, nIndexBase64 + BASE64_MARKER.length())) >= 0);
                    nMIMETypeEnd = nIndexComma;
                } else {
                    nMIMETypeEnd = nIndexComma;
                }
            } else {
                nMIMETypeEnd = nIndexComma;
            }
        }
        String sMimeType = nMIMETypeEnd < 0 ? null : sRest.substring(0, nMIMETypeEnd).trim();
        Charset aCharset = null;
        if (StringHelper.hasNoText((String)sMimeType)) {
            aMimeType = (IMimeType)DEFAULT_MIME_TYPE.getClone();
            aCharset = DEFAULT_CHARSET;
        } else {
            if (sMimeType.charAt(0) == ';') {
                sMimeType = String.valueOf(DEFAULT_MIME_TYPE.getAsStringWithoutParameters()) + sMimeType;
            }
            if ((aMimeType = MimeTypeParser.safeParseMimeType((String)sMimeType, (EMimeQuoting)EMimeQuoting.URL_ESCAPE)) == null) {
                s_aLogger.warn("Data URL contains invalid MIME type: '" + sMimeType + "'");
                return null;
            }
            String sCharsetParam = MimeTypeUtils.getCharsetNameFromMimeType((IMimeType)aMimeType);
            if (sCharsetParam != null) {
                try {
                    aCharset = CharsetManager.getCharsetFromName((String)sCharsetParam);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (aCharset == null) {
                    s_aLogger.warn("Illegal charset '" + sCharsetParam + "' contained. Defaulting to '" + DEFAULT_CHARSET.name() + "'");
                }
            }
            if (aCharset == null) {
                aCharset = DEFAULT_CHARSET;
            }
        }
        String sContent = nIndexComma < 0 ? "" : sRest.substring(nIndexComma + 1).trim();
        byte[] aContent = CharsetManager.getAsBytes((String)sContent, (Charset)aCharset);
        if (bBase64EncodingUsed) {
            if ((aContent = Base64Helper.safeDecode((byte[])aContent)) == null) {
                s_aLogger.warn("Failed to decode Base64 value: " + sContent);
                return null;
            }
            sContent = null;
        }
        CSSDataURL ret = new CSSDataURL(aMimeType, bBase64EncodingUsed, aContent, aCharset, sContent);
        return ret;
    }
}

