/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.IHasStringRepresentation;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.base64.Base64;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.mime.MimeType;
import com.phloc.commons.mime.MimeTypeUtils;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.utils.CSSDataURLHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.omg.CORBA_2_3.portable.OutputStream;

@NotThreadSafe
public class CSSDataURL
implements IHasStringRepresentation,
Serializable {
    private IMimeType m_aMimeType;
    private boolean m_bBase64Encoded;
    private byte[] m_aContent;
    private Charset m_aCharset;
    private String m_sContent;

    @Nonnull
    public static Charset getCharsetFromMimeTypeOrDefault(@Nullable IMimeType aMimeType) {
        Charset ret = MimeTypeUtils.getCharsetFromMimeType((IMimeType)aMimeType);
        return ret != null ? ret : CSSDataURLHelper.DEFAULT_CHARSET;
    }

    public CSSDataURL() {
        this((IMimeType)CSSDataURLHelper.DEFAULT_MIME_TYPE.getClone(), false, new byte[0], CSSDataURLHelper.DEFAULT_CHARSET, "");
    }

    public CSSDataURL(@Nonnull IMimeType aMimeType, boolean bBase64Encoded, @Nonnull byte[] aContent) {
        this(aMimeType, bBase64Encoded, aContent, CSSDataURL.getCharsetFromMimeTypeOrDefault(aMimeType), null);
    }

    public CSSDataURL(@Nonnull IMimeType aMimeType, boolean bBase64Encoded, @Nonnull byte[] aContent, @Nonnull Charset aCharset, @Nullable String sContent) {
        ValueEnforcer.notNull((Object)aMimeType, (String)"MimeType");
        ValueEnforcer.notNull((Object)aContent, (String)"Content");
        ValueEnforcer.notNull((Object)aCharset, (String)"Charset");
        Charset aMimeTypeCharset = MimeTypeUtils.getCharsetFromMimeType((IMimeType)aMimeType);
        if (aMimeTypeCharset == null) {
            this.m_aMimeType = !aCharset.equals(CSSDataURLHelper.DEFAULT_CHARSET) ? ((MimeType)aMimeType.getClone()).addParameter("charset", aCharset.name()) : aMimeType;
        } else {
            if (!aMimeTypeCharset.equals(aCharset)) {
                throw new IllegalArgumentException("The provided charset '" + aCharset.name() + "' differs from the charset in the MIME type: '" + aMimeTypeCharset.name() + "'");
            }
            this.m_aMimeType = aMimeType;
        }
        this.m_bBase64Encoded = bBase64Encoded;
        this.m_aContent = ArrayHelper.getCopy((byte[])aContent);
        this.m_aCharset = aCharset;
        this.m_sContent = sContent;
    }

    private void writeObject(@Nonnull ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_aMimeType);
        out.writeBoolean(this.m_bBase64Encoded);
        out.writeObject(this.m_aContent);
        out.writeUTF(this.m_aCharset.name());
        out.writeObject(this.m_sContent);
    }

    private void readObject(@Nonnull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_aMimeType = (IMimeType)in.readObject();
        this.m_bBase64Encoded = in.readBoolean();
        this.m_aContent = (byte[])in.readObject();
        String sCharsetName = in.readUTF();
        this.m_aCharset = CharsetManager.getCharsetFromName((String)sCharsetName);
        this.m_sContent = (String)in.readObject();
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    public boolean isBase64Encoded() {
        return this.m_bBase64Encoded;
    }

    @Nonnegative
    public int getContentLength() {
        return this.m_aContent.length;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aContent);
    }

    public void writeContentBytes(@Nonnull @WillNotClose OutputStream aOS) throws IOException {
        aOS.write(this.m_aContent, 0, this.m_aContent.length);
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public String getContentAsString() {
        if (this.m_sContent == null) {
            this.m_sContent = CharsetManager.getAsString((byte[])this.m_aContent, (Charset)this.m_aCharset);
        }
        return this.m_sContent;
    }

    @Nonnull
    public String getContentAsBase64EncodedString() {
        byte[] aEncoded = Base64.encodeBytesToBytes((byte[])this.m_aContent);
        return CharsetManager.getAsString((byte[])aEncoded, (Charset)this.m_aCharset);
    }

    @Nonnull
    public String getContentAsString(@Nonnull Charset aCharset) {
        return CharsetManager.getAsString((byte[])this.m_aContent, (Charset)aCharset);
    }

    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bOptimizedVersion) {
        StringBuilder aSB = new StringBuilder("data:");
        if (bOptimizedVersion) {
            if (!this.m_aMimeType.equals(CSSDataURLHelper.DEFAULT_MIME_TYPE)) {
                if (this.m_aMimeType.getAsStringWithoutParameters().equals(CSSDataURLHelper.DEFAULT_MIME_TYPE.getAsStringWithoutParameters())) {
                    aSB.append(this.m_aMimeType.getParametersAsString(CSSDataURLHelper.MIME_QUOTING));
                } else {
                    aSB.append(this.m_aMimeType.getAsString(CSSDataURLHelper.MIME_QUOTING));
                }
            }
        } else {
            aSB.append(this.m_aMimeType.getAsString(CSSDataURLHelper.MIME_QUOTING));
        }
        if (this.m_bBase64Encoded && (this.m_aContent.length > 0 || !bOptimizedVersion)) {
            aSB.append(";base64");
        }
        aSB.append(',');
        if (this.m_aContent.length > 0) {
            if (this.m_bBase64Encoded) {
                aSB.append(this.getContentAsBase64EncodedString());
            } else {
                aSB.append(this.getContentAsString());
            }
        }
        return aSB.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSDataURL rhs = (CSSDataURL)o;
        return this.m_aMimeType.equals(rhs.m_aMimeType) && this.m_bBase64Encoded == rhs.m_bBase64Encoded && EqualsUtils.equals((Object)this.m_aContent, (Object)rhs.m_aContent) && this.m_aCharset.equals(rhs.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aMimeType).append(this.m_bBase64Encoded).append(this.m_aContent).append((Object)this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mimeType", (Object)this.m_aMimeType).append("base64Encoded", this.m_bBase64Encoded).append("content.length", this.m_aContent.length).append("charset", (Object)this.m_aCharset).append("hasStringContent", this.m_sContent != null).toString();
    }
}

