/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.tools;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.reader.CSSReader;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MediaQueryTools {
    private static final MediaQueryTools s_aInstance = new MediaQueryTools();

    private MediaQueryTools() {
    }

    @Nullable
    @Deprecated
    public static List<CSSMediaQuery> parseToMediaQuery(@Nullable String sMediaQuery, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return MediaQueryTools.parseToMediaQuery(sMediaQuery, eVersion);
    }

    @Nullable
    public static List<CSSMediaQuery> parseToMediaQuery(@Nullable String sMediaQuery, @Nonnull ECSSVersion eVersion) {
        if (StringHelper.hasNoText((String)sMediaQuery)) {
            return null;
        }
        String sCSS = "@media " + sMediaQuery + " {}";
        CascadingStyleSheet aCSS = CSSReader.readFromString(sCSS, eVersion);
        if (aCSS == null) {
            return null;
        }
        CSSMediaRule aMediaRule = aCSS.getAllMediaRules().get(0);
        return aMediaRule.getAllMediaQueries();
    }

    @Deprecated
    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet aCSS) {
        return MediaQueryTools.canWrapInMediaQuery(aCSS, false);
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet aCSS, boolean bAllowNestedMediaQueries) {
        if (aCSS == null) {
            return false;
        }
        if (bAllowNestedMediaQueries) {
            return true;
        }
        return !aCSS.hasMediaRules();
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet aCSS, @Nonnull CSSMediaQuery aMediaQuery) {
        return MediaQueryTools.getWrappedInMediaQuery(aCSS, aMediaQuery, false);
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet aCSS, @Nonnull CSSMediaQuery aMediaQuery, boolean bAllowNestedMediaQueries) {
        return MediaQueryTools.getWrappedInMediaQuery(aCSS, ContainerHelper.newList((Object)aMediaQuery), bAllowNestedMediaQueries);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet aCSS, @Nonnull @Nonempty List<CSSMediaQuery> aMediaQueries) {
        return MediaQueryTools.getWrappedInMediaQuery(aCSS, aMediaQueries, false);
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet aCSS, @Nonnull @Nonempty Iterable<? extends CSSMediaQuery> aMediaQueries, boolean bAllowNestedMediaQueries) {
        ValueEnforcer.notNull((Object)aCSS, (String)"CSS");
        ValueEnforcer.notEmpty(aMediaQueries, (String)"MediaQueries");
        if (!MediaQueryTools.canWrapInMediaQuery(aCSS, bAllowNestedMediaQueries)) {
            return null;
        }
        CascadingStyleSheet ret = new CascadingStyleSheet();
        for (CSSImportRule aImportRule : aCSS.getAllImportRules()) {
            if (aImportRule.hasMediaQueries()) {
                ret.addImportRule(aImportRule);
                continue;
            }
            CSSImportRule aNewImportRule = new CSSImportRule(aImportRule.getLocation());
            for (CSSMediaQuery cSSMediaQuery : aMediaQueries) {
                aNewImportRule.addMediaQuery(cSSMediaQuery);
            }
            ret.addImportRule(aNewImportRule);
        }
        for (CSSNamespaceRule aNamespaceRule : aCSS.getAllNamespaceRules()) {
            ret.addNamespaceRule(aNamespaceRule);
        }
        CSSMediaRule aNewMediaRule = new CSSMediaRule();
        for (CSSMediaQuery cSSMediaQuery : aMediaQueries) {
            aNewMediaRule.addMediaQuery(cSSMediaQuery);
        }
        for (ICSSTopLevelRule iCSSTopLevelRule : aCSS.getAllRules()) {
            aNewMediaRule.addRule(iCSSTopLevelRule);
        }
        ret.addRule(aNewMediaRule);
        return ret;
    }
}

