/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader.errorhandler;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.Token;
import com.phloc.css.reader.errorhandler.ICSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingCSSParseErrorHandler.class);
    private static final int TOKEN_EOF = 0;
    private final ICSSParseErrorHandler m_aNestedErrorHandler;

    public LoggingCSSParseErrorHandler() {
        this(null);
    }

    public LoggingCSSParseErrorHandler(@Nullable ICSSParseErrorHandler aNestedErrorHandler) {
        this.m_aNestedErrorHandler = aNestedErrorHandler;
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull ParseException ex) {
        if (ex.currentToken == null) {
            return ex.getMessage();
        }
        return LoggingCSSParseErrorHandler.createLoggingStringParseError(ex.currentToken, ex.expectedTokenSequences, ex.tokenImage, null);
    }

    @Deprecated
    @Nonnull
    @Nonempty
    public static String createLoggingString(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) {
        return LoggingCSSParseErrorHandler.createLoggingStringParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken);
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) {
        ValueEnforcer.notNull((Object)aLastValidToken, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)aExpectedTokenSequencesVal, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)aTokenImageVal, (String)"TokenImageVal");
        StringBuilder aExpected = new StringBuilder();
        int nMaxSize = 0;
        int[][] nArray = aExpectedTokenSequencesVal;
        int n = aExpectedTokenSequencesVal.length;
        int n2 = 0;
        while (n2 < n) {
            int[] aExpectedTokens = nArray[n2];
            if (nMaxSize < aExpectedTokens.length) {
                nMaxSize = aExpectedTokens.length;
            }
            if (aExpected.length() > 0) {
                aExpected.append(',');
            }
            int[] nArray2 = aExpectedTokens;
            int n3 = aExpectedTokens.length;
            int n4 = 0;
            while (n4 < n3) {
                int nExpectedToken = nArray2[n4];
                aExpected.append(' ').append(aTokenImageVal[nExpectedToken]);
                ++n4;
            }
            ++n2;
        }
        StringBuilder retval = new StringBuilder(1024);
        retval.append('[').append(aLastValidToken.next.beginLine).append(':').append(aLastValidToken.next.beginColumn).append(']');
        if (aLastSkippedToken != null) {
            retval.append("-[").append(aLastSkippedToken.endLine).append(':').append(aLastSkippedToken.endColumn).append(']');
        }
        retval.append(" Encountered");
        Token aCurToken = aLastValidToken.next;
        int i = 0;
        while (i < nMaxSize) {
            retval.append(' ');
            if (aCurToken.kind == 0) {
                retval.append(aTokenImageVal[0]);
                break;
            }
            retval.append("text '").append(aCurToken.image).append("' corresponding to token ").append(aTokenImageVal[aCurToken.kind]);
            aCurToken = aCurToken.next;
            ++i;
        }
        retval.append(". ");
        if (aLastSkippedToken != null) {
            retval.append("Skipped until token ").append(aLastSkippedToken).append(". ");
        }
        retval.append(aExpectedTokenSequencesVal.length == 1 ? "Was expecting:" : "Was expecting one of:").append((CharSequence)aExpected);
        return retval.toString();
    }

    @Override
    public void onCSSParseError(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) throws ParseException {
        s_aLogger.warn(LoggingCSSParseErrorHandler.createLoggingStringParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken));
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken);
        }
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) {
        return "[" + aCurrentToken.beginLine + ":" + aCurrentToken.beginColumn + "] Unexpected rule '" + sRule + "': " + sMsg;
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) throws ParseException {
        s_aLogger.warn(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(aCurrentToken, sRule, sMsg));
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSUnexpectedRule(aCurrentToken, sRule, sMsg);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).toString();
    }
}

