/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader.errorhandler;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.Token;
import com.phloc.css.reader.errorhandler.CSSParseError;
import com.phloc.css.reader.errorhandler.ICSSParseErrorHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CollectingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final List<CSSParseError> m_aErrors = new ArrayList<CSSParseError>();
    private final ICSSParseErrorHandler m_aNestedErrorHandler;

    public CollectingCSSParseErrorHandler() {
        this(null);
    }

    public CollectingCSSParseErrorHandler(@Nullable ICSSParseErrorHandler aNestedErrorHandler) {
        this.m_aNestedErrorHandler = aNestedErrorHandler;
    }

    @Override
    public void onCSSParseError(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) throws ParseException {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.add(new CSSParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken);
        }
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) throws ParseException {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.add(CSSParseError.createUnexpectedRule(aCurrentToken, sRule, sMsg));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSUnexpectedRule(aCurrentToken, sRule, sMsg);
        }
    }

    @Nonnegative
    public boolean hasParseErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = !this.m_aErrors.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnegative
    public int getParseErrorCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aErrors.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSParseError> getAllParseErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            List list = ContainerHelper.newList(this.m_aErrors);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("errors", this.m_aErrors).toString();
    }
}

