/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader.errorhandler;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.parser.ReadonlyToken;
import com.phloc.css.parser.Token;
import com.phloc.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSParseError {
    private final ReadonlyToken m_aLastValidToken;
    private final String m_sExpectedTokens;
    private final ReadonlyToken m_aFirstSkippedToken;
    private final ReadonlyToken m_aLastSkippedToken;
    private final String m_sErrorMessage;

    public CSSParseError(@Nonnull @Nonempty String sErrorMsg) {
        ValueEnforcer.notEmpty((CharSequence)sErrorMsg, (String)"ErrorMsg");
        this.m_aLastValidToken = null;
        this.m_sExpectedTokens = null;
        this.m_aFirstSkippedToken = null;
        this.m_aLastSkippedToken = null;
        this.m_sErrorMessage = sErrorMsg;
    }

    public CSSParseError(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) {
        ValueEnforcer.notNull((Object)aLastValidToken, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)aExpectedTokenSequencesVal, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)aTokenImageVal, (String)"TokenImageVal");
        this.m_aLastValidToken = new ReadonlyToken(aLastValidToken);
        StringBuilder aExpected = new StringBuilder();
        int[][] nArray = aExpectedTokenSequencesVal;
        int n = aExpectedTokenSequencesVal.length;
        int n2 = 0;
        while (n2 < n) {
            int[] aExpectedTokens = nArray[n2];
            if (aExpected.length() > 0) {
                aExpected.append(",");
            }
            int[] nArray2 = aExpectedTokens;
            int n3 = aExpectedTokens.length;
            int n4 = 0;
            while (n4 < n3) {
                int nExpectedToken = nArray2[n4];
                aExpected.append(' ').append(aTokenImageVal[nExpectedToken]);
                ++n4;
            }
            ++n2;
        }
        this.m_sExpectedTokens = aExpected.toString();
        this.m_aFirstSkippedToken = new ReadonlyToken(aLastValidToken.next);
        this.m_aLastSkippedToken = aLastSkippedToken == null ? null : new ReadonlyToken(aLastSkippedToken);
        this.m_sErrorMessage = LoggingCSSParseErrorHandler.createLoggingStringParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken);
    }

    @Nullable
    public ReadonlyToken getLastValidToken() {
        return this.m_aLastValidToken;
    }

    @Nullable
    public String getExpectedTokens() {
        return this.m_sExpectedTokens;
    }

    @Nullable
    public ReadonlyToken getFirstSkippedToken() {
        return this.m_aFirstSkippedToken;
    }

    @Nullable
    public ReadonlyToken getLastSkippedToken() {
        return this.m_aLastSkippedToken;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("lastValidToken", (Object)this.m_aLastValidToken).appendIfNotNull("expectedTokens", (Object)this.m_sExpectedTokens).appendIfNotNull("firstSkippedToken", (Object)this.m_aFirstSkippedToken).appendIfNotNull("lastSkippedToken", (Object)this.m_aLastSkippedToken).append("errorMessage", (Object)this.m_sErrorMessage).toString();
    }

    @Nonnull
    public static CSSParseError createUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(aCurrentToken, sRule, sMsg));
    }
}

