/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.handler.CSSHandler;
import com.phloc.css.handler.DoNothingCSSParseExceptionHandler;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.handler.LoggingCSSParseExceptionHandler;
import com.phloc.css.parser.CSSCharStream;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.CharStream;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.ParserCSS21;
import com.phloc.css.parser.ParserCSS21TokenManager;
import com.phloc.css.parser.ParserCSS30;
import com.phloc.css.parser.ParserCSS30TokenManager;
import com.phloc.css.reader.errorhandler.ICSSParseErrorHandler;
import com.phloc.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReaderDeclarationList.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = ThrowingCSSParseErrorHandler.getInstance();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionHandler s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionHandler();
    private static final CSSReaderDeclarationList s_aInstance = new CSSReaderDeclarationList();

    private CSSReaderDeclarationList() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseErrorHandler iCSSParseErrorHandler = s_aDefaultParseErrorHandler;
            return iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler aDefaultParseErrorHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseErrorHandler = aDefaultParseErrorHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public static ICSSParseExceptionHandler getDefaultParseExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseExceptionHandler iCSSParseExceptionHandler = s_aDefaultParseExceptionHandler;
            return iCSSParseExceptionHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionHandler aDefaultParseExceptionHandler) {
        ValueEnforcer.notNull((Object)aDefaultParseExceptionHandler, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseExceptionHandler = aDefaultParseExceptionHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream aStream, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nonnull ICSSParseExceptionHandler aCustomExceptionHandler) {
        switch (eVersion) {
            case CSS21: {
                ParserCSS21TokenManager aTokenHdl = new ParserCSS21TokenManager(aStream);
                ParserCSS21 aParser = new ParserCSS21(aTokenHdl);
                aParser.setCustomErrorHandler(aCustomErrorHandler);
                try {
                    return aParser.styleDeclarationList();
                }
                catch (ParseException ex) {
                    aCustomExceptionHandler.onException(ex);
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager aTokenHdl = new ParserCSS30TokenManager(aStream);
                ParserCSS30 aParser = new ParserCSS30(aTokenHdl);
                aParser.setCustomErrorHandler(aCustomErrorHandler);
                try {
                    return aParser.styleDeclarationList();
                }
                catch (ParseException ex) {
                    aCustomExceptionHandler.onException(ex);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eVersion));
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(aFile), sCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(aFile), aCharset, eVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        return CSSReaderDeclarationList.isValidCSS(aRes, aCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aRes, (String)"Resource");
        ValueEnforcer.notNull((Object)aCharset, (String)"Charset");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        Reader aReader = aRes.getReader(aCharset);
        if (aReader == null) {
            s_aLogger.warn("Failed to open CSS reader " + aRes);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(aReader, eVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull @Nonempty String sCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        ValueEnforcer.notEmpty((CharSequence)sCharset, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)aIS, (String)sCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        ValueEnforcer.notNull((Object)aCharset, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)aIS, (Charset)aCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)sCSS, (String)"CSS");
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(sCSS), eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            CSSNode aNode = CSSReaderDeclarationList._readStyleDeclaration(aCharStream, eVersion, CSSReaderDeclarationList.getDefaultParseErrorHandler(), DoNothingCSSParseExceptionHandler.getInstance());
            boolean bl = aNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromString(sCSS, eVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromString(sCSS, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromString(sCSS, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromFile(aFile, sCharset, eVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromFile(aFile, aCharset, eVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromFile(aFile, sCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromFile(aFile, aCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromFile(aFile, sCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromFile(aFile, aCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        return CSSReaderDeclarationList.readFromFile(aFile, aCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(aCharset), eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aISP, sCharset, eVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(aISP, sCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(aISP, sCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        ValueEnforcer.notNull((Object)aISP, (String)"InputStreamProvider");
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader(StreamUtils.createReader((InputStream)aIS, (Charset)aCharset), eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aIS, sCharset, eVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aIS, aCharset, eVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(aIS, sCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(aIS, aCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(aIS, sCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(aIS, aCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        return CSSReaderDeclarationList.readFromStream(aIS, aCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        return CSSReaderDeclarationList.readFromReader(StreamUtils.createReader((InputStream)aIS, (Charset)aCharset), eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader(aReader, eVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(aReader, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(aReader, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            ICSSParseErrorHandler aRealErrorHandler = aCustomErrorHandler == null ? CSSReaderDeclarationList.getDefaultParseErrorHandler() : aCustomErrorHandler;
            ICSSParseExceptionHandler aRealExceptionHandler = aCustomExceptionHandler == null ? CSSReaderDeclarationList.getDefaultParseExceptionHandler() : aCustomExceptionHandler;
            CSSNode aNode = CSSReaderDeclarationList._readStyleDeclaration(aCharStream, eVersion, aRealErrorHandler, aRealExceptionHandler);
            if (aNode == null) {
                return null;
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eVersion, aNode);
            return cSSDeclarationList;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }
}

