/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.charset.EUnicodeBOM;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.pair.ReadonlyPair;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReaderProvider;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.streamprovider.StringInputStreamProvider;
import com.phloc.commons.io.streamprovider.StringReaderProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.handler.CSSHandler;
import com.phloc.css.handler.DoNothingCSSParseExceptionHandler;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.handler.LoggingCSSParseExceptionHandler;
import com.phloc.css.parser.CSSCharStream;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.CharStream;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.ParseUtils;
import com.phloc.css.parser.ParserCSS21;
import com.phloc.css.parser.ParserCSS21TokenManager;
import com.phloc.css.parser.ParserCSS30;
import com.phloc.css.parser.ParserCSS30TokenManager;
import com.phloc.css.parser.ParserCSSCharsetDetector;
import com.phloc.css.parser.ParserCSSCharsetDetectorTokenManager;
import com.phloc.css.reader.errorhandler.ICSSParseErrorHandler;
import com.phloc.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSSReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReader.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = ThrowingCSSParseErrorHandler.getInstance();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionHandler s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionHandler();
    private static final CSSReader s_aInstance = new CSSReader();

    private CSSReader() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseErrorHandler iCSSParseErrorHandler = s_aDefaultParseErrorHandler;
            return iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler aDefaultParseErrorHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseErrorHandler = aDefaultParseErrorHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public static ICSSParseExceptionHandler getDefaultParseExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseExceptionHandler iCSSParseExceptionHandler = s_aDefaultParseExceptionHandler;
            return iCSSParseExceptionHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionHandler aDefaultParseExceptionHandler) {
        ValueEnforcer.notNull((Object)aDefaultParseExceptionHandler, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseExceptionHandler = aDefaultParseExceptionHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream aStream, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nonnull ICSSParseExceptionHandler aCustomExceptionHandler) {
        switch (eVersion) {
            case CSS21: {
                ParserCSS21TokenManager aTokenHdl = new ParserCSS21TokenManager(aStream);
                ParserCSS21 aParser = new ParserCSS21(aTokenHdl);
                aParser.setCustomErrorHandler(aCustomErrorHandler);
                try {
                    return aParser.styleSheet();
                }
                catch (ParseException ex) {
                    aCustomExceptionHandler.onException(ex);
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager aTokenHdl = new ParserCSS30TokenManager(aStream);
                ParserCSS30 aParser = new ParserCSS30(aTokenHdl);
                aParser.setCustomErrorHandler(aCustomErrorHandler);
                try {
                    return aParser.styleSheet();
                }
                catch (ParseException ex) {
                    aCustomExceptionHandler.onException(ex);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eVersion));
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(aFile), sCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(aFile), aFallbackCharset, eVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        Charset aFallbackCharset = CharsetManager.getCharsetFromName((String)sCharset);
        return CSSReader.isValidCSS(aRes, aFallbackCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aRes, (String)"Resource");
        ValueEnforcer.notNull((Object)aFallbackCharset, (String)"FallbackCharset");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        Reader aReader = aRes.getReader(aFallbackCharset);
        if (aReader == null) {
            s_aLogger.warn("Failed to open CSS reader " + aRes);
            return false;
        }
        return CSSReader.isValidCSS(aReader, eVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull @Nonempty String sCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        ValueEnforcer.notEmpty((CharSequence)sCharset, (String)"Charset");
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)aIS, (String)sCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        ValueEnforcer.notNull((Object)aFallbackCharset, (String)"FallbackCharset");
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)aIS, (Charset)aFallbackCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)sCSS, (String)"CSS");
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(sCSS), eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            CSSNode aNode = CSSReader._readStyleSheet(aCharStream, eVersion, CSSReader.getDefaultParseErrorHandler(), DoNothingCSSParseExceptionHandler.getInstance());
            boolean bl = aNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromString(sCSS, sCharset, eVersion, null, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromString(sCSS, aFallbackCharset, eVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromString(sCSS, sCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromString(sCSS, aFallbackCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromString(sCSS, sCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromString(sCSS, aFallbackCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(sCSS, sCharset), sCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(sCSS, aFallbackCharset), aFallbackCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromReader((IReaderProvider)new StringReaderProvider(sCSS), eVersion, null, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromReader((IReaderProvider)new StringReaderProvider(sCSS), eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromReader((IReaderProvider)new StringReaderProvider(sCSS), eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromReader((IReaderProvider)new StringReaderProvider(sCSS), eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromFile(aFile, sCharset, eVersion, null, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromFile(aFile, aFallbackCharset, eVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromFile(aFile, sCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromFile(aFile, aFallbackCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(aFile), sCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(aFile), aFallbackCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(aFile), sCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(aFile), aFallbackCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStream(aISP, sCharset, eVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromStream(aISP, sCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStream(aISP, aFallbackCharset, eVersion, null, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromStream(aISP, aFallbackCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream(aISP, sCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        Charset aFallbackCharset = CharsetManager.getCharsetFromName((String)sCharset);
        return CSSReader.readFromStream(aISP, aFallbackCharset, eVersion, aCustomErrorHandler, aCustomExceptionHandler);
    }

    @Nullable
    private static ReadonlyPair<InputStream, Charset> _getInputStreamWithoutBOM(@Nonnull IInputStreamProvider aISP) {
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        int nMaxBOMBytes = EUnicodeBOM.getMaximumByteCount();
        PushbackInputStream aPIS = new PushbackInputStream(aIS, nMaxBOMBytes);
        try {
            byte[] aBOM = new byte[nMaxBOMBytes];
            int nReadBOMBytes = aPIS.read(aBOM);
            Charset aDeterminedCharset = null;
            if (nReadBOMBytes > 0) {
                EUnicodeBOM eBOM = EUnicodeBOM.getFromBytesOrNull((byte[])ArrayHelper.getCopy((byte[])aBOM, (int)0, (int)nReadBOMBytes));
                if (eBOM == null) {
                    aPIS.unread(aBOM, 0, nReadBOMBytes);
                } else {
                    int nBOMBytes = eBOM.getByteCount();
                    if (nBOMBytes < nReadBOMBytes) {
                        aPIS.unread(aBOM, nBOMBytes, nReadBOMBytes - nBOMBytes);
                    }
                    aDeterminedCharset = eBOM.getCharset();
                }
            }
            return new ReadonlyPair((Object)aPIS, aDeterminedCharset);
        }
        catch (IOException ex) {
            s_aLogger.error("Failed to determine BOM", (Throwable)ex);
            return null;
        }
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IInputStreamProvider aISP) {
        ValueEnforcer.notNull((Object)aISP, (String)"InputStreamProvider");
        ReadonlyPair<InputStream, Charset> aISAndBOM = CSSReader._getInputStreamWithoutBOM(aISP);
        if (aISAndBOM == null || aISAndBOM.getFirst() == null) {
            return null;
        }
        InputStream aIS = (InputStream)aISAndBOM.getFirst();
        Charset aBOMCharset = (Charset)aISAndBOM.getSecond();
        Charset aStreamCharset = aBOMCharset;
        if (aStreamCharset == null) {
            aStreamCharset = CCharset.CHARSET_ISO_8859_1_OBJ;
        }
        try {
            CSSCharStream aCharStream = new CSSCharStream(StreamUtils.createReader((InputStream)aIS, (Charset)aStreamCharset));
            ParserCSSCharsetDetectorTokenManager aTokenHdl = new ParserCSSCharsetDetectorTokenManager(aCharStream);
            ParserCSSCharsetDetector aParser = new ParserCSSCharsetDetector(aTokenHdl);
            String sCharsetName = aParser.styleSheetCharset().getText();
            if (sCharsetName == null) {
                Charset charset = (Charset)aISAndBOM.getSecond();
                return charset;
            }
            String sPlainCharsetName = ParseUtils.extractStringValue(sCharsetName);
            Charset aReadCharset = CharsetManager.getCharsetFromName((String)sPlainCharsetName);
            if (aBOMCharset != null && !aBOMCharset.equals(aReadCharset)) {
                s_aLogger.warn("The charset found in the CSS data (" + aReadCharset.name() + ") differs from the charset determined by the BOM (" + aBOMCharset.name() + ")!");
            }
            Charset charset = aReadCharset;
            return charset;
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Failed to parse CSS charset definition", ex);
        }
        finally {
            StreamUtils.close((Closeable)aIS);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReader.readFromStream(aISP, aFallbackCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        Charset aCharsetToUse;
        ValueEnforcer.notNull((Object)aISP, (String)"InputStreamProvider");
        ValueEnforcer.notNull((Object)aFallbackCharset, (String)"FallbackCharset");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        Charset aDeclaredCharset = CSSReader.getCharsetDeclaredInCSS(aISP);
        if (aDeclaredCharset != null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Reading CSS definition again with explicit charset '" + aDeclaredCharset.name() + "'");
            }
            aCharsetToUse = aDeclaredCharset;
        } else {
            aCharsetToUse = aFallbackCharset;
        }
        ReadonlyPair<InputStream, Charset> aISAndBOM = CSSReader._getInputStreamWithoutBOM(aISP);
        if (aISAndBOM == null || aISAndBOM.getFirst() == null) {
            return null;
        }
        InputStream aIS = (InputStream)aISAndBOM.getFirst();
        try {
            CSSCharStream aCharStream = new CSSCharStream(StreamUtils.createReader((InputStream)aIS, (Charset)aCharsetToUse));
            ICSSParseErrorHandler aRealErrorHandler = aCustomErrorHandler == null ? CSSReader.getDefaultParseErrorHandler() : aCustomErrorHandler;
            ICSSParseExceptionHandler aRealExceptionHandler = aCustomExceptionHandler == null ? CSSReader.getDefaultParseExceptionHandler() : aCustomExceptionHandler;
            CSSNode aNode = CSSReader._readStyleSheet(aCharStream, eVersion, aRealErrorHandler, aRealExceptionHandler);
            if (aNode == null) {
                return null;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eVersion, aNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamUtils.close((Closeable)aIS);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IReaderProvider aRP, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        ValueEnforcer.notNull((Object)aRP, (String)"ReaderProvider");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        Reader aReader = aRP.getReader();
        if (aReader == null) {
            return null;
        }
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            ICSSParseErrorHandler aRealErrorHandler = aCustomErrorHandler == null ? CSSReader.getDefaultParseErrorHandler() : aCustomErrorHandler;
            ICSSParseExceptionHandler aRealExceptionHandler = aCustomExceptionHandler == null ? CSSReader.getDefaultParseExceptionHandler() : aCustomExceptionHandler;
            CSSNode aNode = CSSReader._readStyleSheet(aCharStream, eVersion, aRealErrorHandler, aRealExceptionHandler);
            if (aNode == null) {
                return null;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eVersion, aNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }
}

