/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.ICSSMultiValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSValueMultiValue
implements ICSSMultiValue {
    private final List<CSSValue> m_aValues = new ArrayList<CSSValue>();

    public CSSValueMultiValue(@Nonnull ICSSProperty aProperty, @Nonnull @Nonempty String[] aValues, boolean bIsImportant) {
        ValueEnforcer.notNull((Object)aProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])aValues, (String)"Values");
        String[] stringArray = aValues;
        int n = aValues.length;
        int n2 = 0;
        while (n2 < n) {
            String sValue = stringArray[n2];
            this.m_aValues.add(new CSSValue(aProperty, sValue, bIsImportant));
            ++n2;
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSValue> getContainedValues() {
        return ContainerHelper.newList(this.m_aValues);
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return ((CSSValue)ContainerHelper.getFirstElement(this.m_aValues)).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder ret = new StringBuilder();
        for (CSSValue aValue : this.m_aValues) {
            ret.append(aValue.getAsCSSString(aSettings, nIndentLevel));
        }
        return ret.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSValueMultiValue rhs = (CSSValueMultiValue)o;
        return this.m_aValues.equals(rhs.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).toString();
    }
}

