/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.AbstractCSSProperty;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.customizer.ICSSPropertyCustomizer;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyNumbers
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyNumbers(@Nonnull ECSSProperty eProp, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers) {
        this(eProp, null, bWithPercentage, nMinNumbers, nMaxNumbers);
    }

    public CSSPropertyNumbers(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers) {
        super(eProp, aCustomizer);
        ValueEnforcer.isGT0((int)nMinNumbers, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxNumbers, (String)"MaxNumbers");
        if (nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("MaxNumbers (" + nMaxNumbers + ") must be >= MinNumbers (" + nMinNumbers + ")");
        }
        this.m_bWithPercentage = bWithPercentage;
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        if (super.isValidValue(sValue)) {
            return true;
        }
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.m_nMinNumbers || aParts.length > this.m_nMaxNumbers) {
            return false;
        }
        String[] stringArray = aParts;
        int n = aParts.length;
        int n2 = 0;
        while (n2 < n) {
            String sPart = stringArray[n2];
            if (!CSSNumberHelper.isValueWithUnit(sPart.trim(), this.m_bWithPercentage)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyNumbers getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyNumbers(eProp, this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyNumbers rhs = (CSSPropertyNumbers)o;
        return this.m_bWithPercentage == rhs.m_bWithPercentage && this.m_nMinNumbers == rhs.m_nMinNumbers && this.m_nMaxNumbers == rhs.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

