/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.CSSPropertyEnum;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.customizer.ICSSPropertyCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, null, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        super(eProp, aCustomizer, aEnumValues);
        ValueEnforcer.isGT0((int)nMinNumbers, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxNumbers, (String)"MaxNumbers");
        if (nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("MaxNumbers (" + nMaxNumbers + ") must be >= MinNumbers (" + nMinNumbers + ")");
        }
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, null, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, aCustomizer, aEnumValues);
        ValueEnforcer.isGT0((int)nMinNumbers, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxNumbers, (String)"MaxNumbers");
        if (nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("MaxNumbers (" + nMaxNumbers + ") must be >= MinNumbers (" + nMinNumbers + ")");
        }
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.m_nMinNumbers || aParts.length > this.m_nMaxNumbers) {
            return false;
        }
        String[] stringArray = aParts;
        int n = aParts.length;
        int n2 = 0;
        while (n2 < n) {
            String sPart = stringArray[n2];
            if (!super.isValidValue(sPart.trim())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnums(eProp, this.getCustomizer(), this.m_nMinNumbers, this.m_nMaxNumbers, this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyEnums rhs = (CSSPropertyEnums)o;
        return this.m_nMinNumbers == rhs.m_nMinNumbers && this.m_nMaxNumbers == rhs.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

