/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.AbstractCSSProperty;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.customizer.ICSSPropertyCustomizer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnum
extends AbstractCSSProperty {
    private final Set<String> m_aEnumValues;

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, String ... aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, aEnumValues);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, String ... aEnumValues) {
        super(eProp, aCustomizer);
        ValueEnforcer.notEmptyNoNullValue((Object[])aEnumValues, (String)"EnumValues");
        this.m_aEnumValues = new HashSet<String>(aEnumValues.length);
        String[] stringArray = aEnumValues;
        int n = aEnumValues.length;
        int n2 = 0;
        while (n2 < n) {
            String sPotentialValue = stringArray[n2];
            if (StringHelper.hasNoText((String)sPotentialValue)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(sPotentialValue);
            ++n2;
        }
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, null, aEnumValues);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, aCustomizer);
        ValueEnforcer.notEmptyNoNullValue(aEnumValues, (String)"EnumValues");
        this.m_aEnumValues = new HashSet<String>();
        for (String sPotentialValue : aEnumValues) {
            if (StringHelper.hasNoText((String)sPotentialValue)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add(sPotentialValue);
        }
    }

    private CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnull @Nonempty Set<String> aEnumValues) {
        super(eProp, aCustomizer);
        this.m_aEnumValues = ContainerHelper.newSet(aEnumValues);
    }

    @Nonnull
    @ReturnsMutableObject(reason="Design")
    protected final Set<String> directGetEnumValues() {
        return this.m_aEnumValues;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        return super.isValidValue(sValue) || this.m_aEnumValues.contains(sValue);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnum(eProp, this.getCustomizer(), this.m_aEnumValues);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyEnum rhs = (CSSPropertyEnum)o;
        return this.m_aEnumValues.equals(rhs.m_aEnumValues);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aEnumValues).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("enumValues", this.m_aEnumValues).toString();
    }
}

