/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.property.customizer.ICSSPropertyCustomizer;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.ICSSValue;
import com.phloc.css.utils.ICSSNamedColor;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSSProperty
implements ICSSProperty {
    private final ECSSProperty m_eProp;
    private final ICSSPropertyCustomizer m_aCustomizer;

    protected AbstractCSSProperty(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer) {
        this.m_eProp = (ECSSProperty)ValueEnforcer.notNull((Object)eProp, (String)"Property");
        this.m_aCustomizer = aCustomizer;
    }

    @Override
    @Nonnull
    public final ECSSVersion getMinimumCSSVersion() {
        return this.m_eProp.getMinimumCSSVersion();
    }

    @Override
    @Nonnull
    public final ECSSProperty getProp() {
        return this.m_eProp;
    }

    @Override
    @Nullable
    public final ICSSPropertyCustomizer getCustomizer() {
        return this.m_aCustomizer;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMinimumArgumentCount() {
        return 1;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMaximumArgumentCount() {
        return 1;
    }

    public static boolean isValidPropertyValue(@Nullable String sValue) {
        return "inherit".equals(sValue) || "initial".equals(sValue);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        return AbstractCSSProperty.isValidPropertyValue(sValue);
    }

    @Override
    @Nonnull
    public ICSSValue newValue(@Nonnull @Nonempty String sValue, boolean bIsImportant) {
        ICSSValue aCustomizedValue;
        ValueEnforcer.notEmpty((CharSequence)sValue, (String)"Value");
        if (this.m_aCustomizer != null && (aCustomizedValue = this.m_aCustomizer.createSpecialValue(this, sValue, bIsImportant)) != null) {
            return aCustomizedValue;
        }
        return new CSSValue(this, sValue, bIsImportant);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull @Nonempty String sValue) {
        return this.newValue(sValue, false);
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull @Nonempty String sValue) {
        return this.newValue(sValue, true);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull ICSSNamedColor aColor, boolean bImportant) {
        return this.newValue(aColor.getName(), bImportant);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull ICSSNamedColor aColor) {
        return this.newValue(aColor.getName());
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull ICSSNamedColor aColor) {
        return this.newImportantValue(aColor.getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractCSSProperty rhs = (AbstractCSSProperty)o;
        return this.m_eProp.equals(rhs.m_eProp);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eProp).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prop", (Enum)this.m_eProp).toString();
    }
}

