/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.parser;

import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.parser.TokenMgrError;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ParseUtils {
    public static final char URL_ESCAPE_CHAR = '\\';
    @RegEx
    private static final String SPLIT_NUMBER_REGEX = "^([0-9]*\\.[0-9]+|[0-9]+).*$";
    private static final ParseUtils s_aInstance = new ParseUtils();

    private ParseUtils() {
    }

    @Nonnull
    private static String _trimBy(@Nonnull CharSequence s, int nLeftSkip, int nRightSkip) {
        return s.toString().substring(nLeftSkip, s.length() - nRightSkip);
    }

    @Nullable
    public static String extractStringValue(@Nullable String sStr) {
        if (StringHelper.hasNoText((String)sStr) || sStr.length() < 2) {
            return sStr;
        }
        char cFirst = sStr.charAt(0);
        if ((cFirst == '\"' || cFirst == '\'') && StringHelper.getLastChar((CharSequence)sStr) == cFirst) {
            return ParseUtils._trimBy(sStr, 1, 1);
        }
        return sStr;
    }

    @Nonnull
    public static String unescapeURL(@Nonnull String sEscapedURL) {
        int nIndex = sEscapedURL.indexOf(92);
        if (nIndex < 0) {
            return sEscapedURL;
        }
        StringBuilder aSB = new StringBuilder(sEscapedURL.length());
        int nPrevIndex = 0;
        do {
            aSB.append(sEscapedURL, nPrevIndex, nIndex);
            aSB.append(sEscapedURL, nIndex + 1, nIndex + 2);
        } while ((nIndex = sEscapedURL.indexOf(92, nPrevIndex = nIndex + 2)) >= 0);
        aSB.append(sEscapedURL.substring(nPrevIndex));
        return aSB.toString();
    }

    @Nonnull
    public static String trimUrl(@Nonnull CharSequence s) {
        String sTrimmed = ParseUtils._trimBy(s, "url(".length(), ")".length()).trim();
        String sUnquoted = ParseUtils.extractStringValue(sTrimmed);
        return ParseUtils.unescapeURL(sUnquoted);
    }

    @Nonnull
    public static String splitNumber(@Nonnull StringBuilder aPattern) {
        Matcher m = RegExHelper.getMatcher((String)SPLIT_NUMBER_REGEX, (String)aPattern.toString());
        if (m.matches()) {
            return m.group(1);
        }
        return "";
    }

    @Nonnull
    public static String validateIdentifier(@Nonnull StringBuilder aPattern) {
        char c2;
        int nLength = aPattern.length();
        char c1 = aPattern.charAt(0);
        char c = c2 = nLength <= 1 ? (char)'\u0000' : aPattern.charAt(1);
        if (c1 == '-' || c1 == '$' || c1 == '*') {
            if (nLength > 1 && Character.isDigit(c2)) {
                throw new TokenMgrError("Identifier may not start with a hyphen and a digit: " + aPattern, 0);
            }
        } else if (Character.isDigit(c1)) {
            throw new TokenMgrError("Identifier may not start with a digit: " + aPattern, 0);
        }
        if (nLength > 1 && c1 == '-' && c2 == '-') {
            throw new TokenMgrError("Identifier may not start with two hyphens: " + aPattern, 0);
        }
        return aPattern.toString();
    }

    @Nonnull
    public static String unescapeUnicode(StringBuilder aImage) {
        return aImage.toString();
    }

    @Nonnull
    public static String unescapeOther(StringBuilder aImage) {
        return aImage.toString();
    }
}

