/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.parser;

import com.phloc.css.parser.Token;
import java.util.HashSet;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    public String errorTokenMessage;
    public int errorTokenLength;
    public int errorTokenBeginLine;
    public int errorTokenBeginColumn;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.createErrorToken();
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        HashSet<String> expecteSet = new HashSet<String>();
        int expectNum = 0;
        int i = 0;
        while (i < expectedTokenSequences.length) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            boolean append = false;
            int j = 0;
            while (j < expectedTokenSequences[i].length && expectNum <= 5) {
                String expect = tokenImage[expectedTokenSequences[i][j]];
                if (expecteSet.add(expect)) {
                    expected.append(expect).append(' ');
                    ++expectNum;
                    append = true;
                }
                ++j;
            }
            if (append) {
                if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                    expected.append("\u3001");
                }
                expected.append(EOL);
                if (expectNum <= 5) {
                    expected.append("    ");
                } else {
                    expected.append("...");
                }
            }
            ++i;
        }
        String retval = "Unexpected \"";
        Token tok = currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + ParseException.add_escapes(tok.image);
            tok = tok.next;
            ++i2;
        }
        retval = String.valueOf(retval) + "\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
        retval = String.valueOf(retval) + "." + EOL;
        return retval;
    }

    private void createErrorToken() {
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            ++i;
        }
        StringBuffer retval = new StringBuffer();
        Token tok = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            retval.append(ParseException.add_escapes(tok.image));
            this.errorTokenLength += tok.toString().length();
            tok = tok.next;
            ++i2;
        }
        this.errorTokenMessage = retval.toString();
        this.errorTokenBeginLine = this.currentToken.next.beginLine;
        this.errorTokenBeginColumn = this.currentToken.next.beginColumn;
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

