/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.parser;

import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceArea;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.parser.Node;
import com.phloc.css.parser.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSNode
implements Node,
Iterable<CSSNode>,
Serializable {
    private final int m_nType;
    private CSSNode m_aParent;
    private CSSNode[] m_aChildren;
    private Object m_aValue;
    private String m_sText;
    private Token m_aFirstToken;
    private Token m_aLastToken;

    public CSSNode(int nType) {
        this.m_nType = nType;
    }

    @Override
    public int getId() {
        return this.m_nType;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(@Nullable Node aNode) {
        this.m_aParent = (CSSNode)aNode;
    }

    @Override
    @Nullable
    public Node jjtGetParent() {
        return this.m_aParent;
    }

    @Override
    public void jjtAddChild(Node aNode, int nIndex) {
        if (this.m_aChildren == null) {
            this.m_aChildren = new CSSNode[nIndex + 1];
        } else if (nIndex >= this.m_aChildren.length) {
            CSSNode[] aTmpArray = new CSSNode[nIndex + 1];
            System.arraycopy(this.m_aChildren, 0, aTmpArray, 0, this.m_aChildren.length);
            this.m_aChildren = aTmpArray;
        }
        this.m_aChildren[nIndex] = (CSSNode)aNode;
    }

    @Override
    public CSSNode jjtGetChild(int nIndex) {
        return this.m_aChildren[nIndex];
    }

    @Override
    @Nonnegative
    public int jjtGetNumChildren() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.length;
    }

    @Nullable
    public Token jjtGetFirstToken() {
        return this.m_aFirstToken;
    }

    public void jjtSetFirstToken(@Nonnull Token aFirstToken) {
        this.m_aFirstToken = aFirstToken;
    }

    @Nullable
    public Token jjtGetLastToken() {
        return this.m_aLastToken;
    }

    public void jjtSetLastToken(@Nonnull Token aLastToken) {
        this.m_aLastToken = aLastToken;
    }

    public void setValue(@Nullable Object aValue) {
        this.m_aValue = aValue;
    }

    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    public void setText(@Nullable String sText) {
        this.m_sText = sText;
    }

    public void appendText(@Nonnull String sText) {
        this.m_sText = this.m_sText == null ? sText : String.valueOf(this.m_sText) + sText;
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    public boolean hasText() {
        return this.m_sText != null;
    }

    public int getNodeType() {
        return this.m_nType;
    }

    @Override
    @Nonnull
    public Iterator<CSSNode> iterator() {
        ArrayList<CSSNode> aChildren = new ArrayList<CSSNode>(this.jjtGetNumChildren());
        if (this.m_aChildren != null) {
            CSSNode[] cSSNodeArray = this.m_aChildren;
            int n = this.m_aChildren.length;
            int n2 = 0;
            while (n2 < n) {
                CSSNode aChildNode = cSSNodeArray[n2];
                if (aChildNode != null) {
                    aChildren.add(aChildNode);
                }
                ++n2;
            }
        }
        return aChildren.iterator();
    }

    @Nullable
    public CSSSourceLocation getSourceLocation() {
        CSSSourceArea aLastTokenArea;
        CSSSourceArea aFirstTokenArea = this.m_aFirstToken == null ? null : new CSSSourceArea(this.m_aFirstToken.beginLine, this.m_aFirstToken.beginColumn, this.m_aFirstToken.endLine, this.m_aFirstToken.endColumn);
        CSSSourceArea cSSSourceArea = aLastTokenArea = this.m_aLastToken == null ? null : new CSSSourceArea(this.m_aLastToken.beginLine, this.m_aLastToken.beginColumn, this.m_aLastToken.endLine, this.m_aLastToken.endColumn);
        if (aFirstTokenArea == null && aLastTokenArea == null) {
            return null;
        }
        return new CSSSourceLocation(aFirstTokenArea, aLastTokenArea);
    }

    public void dump(String prefix) {
        System.out.println(String.valueOf(prefix) + this.toString());
        if (this.m_aChildren != null) {
            CSSNode[] cSSNodeArray = this.m_aChildren;
            int n = this.m_aChildren.length;
            int n2 = 0;
            while (n2 < n) {
                CSSNode aChild = cSSNodeArray[n2];
                if (aChild != null) {
                    aChild.dump(String.valueOf(prefix) + " ");
                }
                ++n2;
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", this.m_nType).appendIfNotNull("parentType", this.m_aParent == null ? null : Integer.valueOf(this.m_aParent.m_nType)).appendIfNotNull("value", this.m_aValue).appendIfNotNull("text", (Object)this.m_sText).append("children#", this.m_aChildren == null ? 0 : this.m_aChildren.length).appendIfNotNull("firstToken", (Object)this.m_aFirstToken).appendIfNotNull("lastToken", (Object)this.m_aLastToken).toString();
    }
}

