/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.media;

import com.phloc.commons.IHasSize;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.media.ECSSMedium;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaList
implements Serializable,
IHasSize {
    public static final String DEFAULT_MEDIA_STRING_SEPARATOR = ", ";
    private final Set<ECSSMedium> m_aMedia = new LinkedHashSet<ECSSMedium>();

    public CSSMediaList() {
    }

    public CSSMediaList(@Nonnull ECSSMedium eMedium) {
        this.addMedium(eMedium);
    }

    public CSSMediaList(ECSSMedium ... aMedia) {
        if (aMedia != null) {
            ECSSMedium[] eCSSMediumArray = aMedia;
            int n = aMedia.length;
            int n2 = 0;
            while (n2 < n) {
                ECSSMedium eMedium = eCSSMediumArray[n2];
                this.addMedium(eMedium);
                ++n2;
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> aMedia) {
        if (aMedia != null) {
            for (ECSSMedium eMedium : aMedia) {
                this.addMedium(eMedium);
            }
        }
    }

    @Nonnull
    public CSSMediaList addMedium(@Nonnull ECSSMedium eMedium) {
        ValueEnforcer.notNull((Object)eMedium, (String)"Medium");
        this.m_aMedia.add(eMedium);
        return this;
    }

    @Nonnull
    public EChange removeMedium(@Nullable ECSSMedium eMedium) {
        return EChange.valueOf((boolean)this.m_aMedia.remove(eMedium));
    }

    @Nonnull
    public EChange removeAllMedia() {
        if (this.m_aMedia.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMedia.clear();
        return EChange.CHANGED;
    }

    @Nonnegative
    public int getMediaCount() {
        return this.m_aMedia.size();
    }

    public boolean hasAnyMedia() {
        return !this.m_aMedia.isEmpty();
    }

    public boolean hasNoMedia() {
        return this.m_aMedia.isEmpty();
    }

    public boolean hasNoMediaOrAll() {
        return this.hasNoMedia() || this.containsMedium(ECSSMedium.ALL);
    }

    public boolean containsMedium(@Nullable ECSSMedium eMedium) {
        return this.m_aMedia.contains(eMedium);
    }

    public boolean containsMediumOrAll(@Nullable ECSSMedium eMedium) {
        return this.containsMedium(eMedium) || this.containsMedium(ECSSMedium.ALL);
    }

    public boolean isForScreen() {
        return this.hasNoMedia() || this.containsMediumOrAll(ECSSMedium.SCREEN);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<ECSSMedium> getAllMedia() {
        return ContainerHelper.newSet(this.m_aMedia);
    }

    @Nonnull
    public String getMediaString() {
        return this.getMediaString(DEFAULT_MEDIA_STRING_SEPARATOR);
    }

    @Nonnull
    public String getMediaString(@Nonnull String sSeparator) {
        ValueEnforcer.notNull((Object)sSeparator, (String)"Separator");
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        StringBuilder aSB = new StringBuilder();
        for (ECSSMedium eMedia : this.m_aMedia) {
            if (aSB.length() > 0) {
                aSB.append(sSeparator);
            }
            aSB.append(eMedia.getName());
        }
        return aSB.toString();
    }

    @Nonnegative
    public int size() {
        return this.getMediaCount();
    }

    public boolean isEmpty() {
        return this.hasNoMedia();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaList rhs = (CSSMediaList)o;
        return this.m_aMedia.equals(rhs.m_aMedia);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMedia).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("media", this.m_aMedia).toString();
    }
}

