/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.css.ECSSVersion;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.ParserCSS21TreeConstants;
import com.phloc.css.parser.ParserCSS30TreeConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2, 2),
    CHARSET(8, 13),
    UNKNOWNRULE(35, 57),
    UNKNOWNRULEPARAMETERLIST(33, 55),
    UNKNOWNRULEBODY(34, 56),
    STYLERULE(27, 34),
    IMPORTRULE(9, 14),
    PAGERULE(32, 43),
    MEDIARULE(30, 41),
    FONTFACERULE(-1, 44),
    SELECTOR(22, 29),
    STYLEDECLARATIONLIST(26, 33),
    STYLEDECLARATION(25, 32),
    NAMESPACEPREFIX(13, 18),
    ELEMENTNAME(14, 19),
    HASH(15, 20),
    CLASS(16, 21),
    PSEUDO(20, 26),
    NEGATION(-1, 27),
    ATTRIB(19, 24),
    ATTRIBOPERATOR(17, 22),
    ATTRIBVALUE(18, 23),
    SELECTORCOMBINATOR(21, 28),
    NTH(-1, 25),
    PROPERTY(23, 30),
    IMPORTANT(24, 31),
    EXPR(7, 12),
    EXPRTERM(5, 10),
    EXPROPERATOR(6, 11),
    URL(3, 3),
    FUNCTION(4, 4),
    MATH(-1, 9),
    MATHSUMOPERATOR(-1, 8),
    MATHPRODUCT(-1, 7),
    MATHPRODUCTOPERATOR(-1, 6),
    MATHUNIT(-1, 5),
    MEDIALIST(29, 40),
    MEDIUM(28, 36),
    MEDIAQUERY(-1, 39),
    MEDIAMODIFIER(-1, 35),
    MEDIAEXPR(-1, 38),
    MEDIAFEATURE(-1, 37),
    PSEUDOPAGE(31, 42),
    KEYFRAMESRULE(-1, 48),
    KEYFRAMESIDENTIFIER(-1, 45),
    KEYFRAMESSELECTOR(-1, 47),
    SINGLEKEYFRAMESELECTOR(-1, 46),
    VIEWPORTRULE(-1, 49),
    NAMESPACERULE(12, 17),
    NAMESPACERULEPREFIX(10, 15),
    NAMESPACERULEURL(11, 16),
    SUPPORTSRULE(-1, 54),
    SUPPORTSCONDITION(-1, 53),
    SUPPORTSCONDITIONOPERATOR(-1, 52),
    SUPPORTSNEGATION(-1, 51),
    SUPPORTSCONDITIONINPARENS(-1, 50),
    ERROR_SKIPTO(1, 1);

    private static final Logger s_aLogger;
    private final int m_nParserType21;
    private final int m_nParserType30;

    static {
        s_aLogger = LoggerFactory.getLogger(ECSSNodeType.class);
    }

    private ECSSNodeType(int nParserType21, int nParserType30) {
        this.m_nParserType21 = nParserType21;
        this.m_nParserType30 = nParserType30;
    }

    int getParserNodeType(@Nonnull ECSSVersion eVersion) {
        switch (eVersion) {
            case CSS21: {
                return this.m_nParserType21;
            }
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eVersion));
    }

    public boolean isNode(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        return aParserNode.getNodeType() == this.getParserNodeType(eVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eVersion) {
        switch (eVersion) {
            case CSS21: {
                return this.m_nParserType21 == -1 ? this.name() : ParserCSS21TreeConstants.jjtNodeName[this.m_nParserType21];
            }
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        ECSSNodeType[] eCSSNodeTypeArray = ECSSNodeType.values();
        int n = eCSSNodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ECSSNodeType eNodeType = eCSSNodeTypeArray[n2];
            if (eNodeType.isNode(aParserNode, eVersion)) {
                return eNodeType;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        ECSSNodeType eNodeType = ECSSNodeType.getNodeType(aParserNode, eVersion);
        if (eNodeType != null) {
            return eNodeType.getNodeName(eVersion);
        }
        s_aLogger.warn("Unsupported node type " + aParserNode.getNodeType() + " in version " + (Object)((Object)eVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion, @Nonnull StringBuilder aSB, @Nonnull String sPrefix) {
        aSB.append(sPrefix).append(ECSSNodeType.getNodeName(aParserNode, eVersion));
        if (aParserNode.hasText()) {
            aSB.append('[').append(aParserNode.getText()).append(']');
        }
        aSB.append('\n');
        for (CSSNode aChildNode : aParserNode) {
            ECSSNodeType._dumpRecursive(aChildNode, eVersion, aSB, String.valueOf(sPrefix) + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        StringBuilder aSB = new StringBuilder();
        ECSSNodeType._dumpRecursive(aParserNode, eVersion, aSB, "");
        return aSB.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        return ERROR_SKIPTO.isNode(aParserNode, eVersion);
    }
}

