/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberFunction;
import com.phloc.css.decl.CSSExpressionMemberMath;
import com.phloc.css.decl.CSSExpressionMemberMathProduct;
import com.phloc.css.decl.CSSExpressionMemberMathUnitProduct;
import com.phloc.css.decl.CSSExpressionMemberMathUnitSimple;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaExpression;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSSelectorAttribute;
import com.phloc.css.decl.CSSSelectorMemberFunctionLike;
import com.phloc.css.decl.CSSSelectorMemberNot;
import com.phloc.css.decl.CSSSelectorSimpleMember;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSSupportsConditionDeclaration;
import com.phloc.css.decl.CSSSupportsConditionNegation;
import com.phloc.css.decl.CSSSupportsConditionNested;
import com.phloc.css.decl.CSSSupportsRule;
import com.phloc.css.decl.CSSURI;
import com.phloc.css.decl.CSSUnknownRule;
import com.phloc.css.decl.CSSViewportRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ECSSAttributeOperator;
import com.phloc.css.decl.ECSSExpressionOperator;
import com.phloc.css.decl.ECSSMathOperator;
import com.phloc.css.decl.ECSSSelectorCombinator;
import com.phloc.css.decl.ECSSSupportsConditionOperator;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.ICSSSelectorMember;
import com.phloc.css.decl.ICSSSupportsConditionMember;
import com.phloc.css.handler.CSSHandlingException;
import com.phloc.css.handler.ECSSNodeType;
import com.phloc.css.media.ECSSMediaExpressionFeature;
import com.phloc.css.media.ECSSMedium;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.ParseUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class CSSNodeToDomainObject {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSNodeToDomainObject.class);
    private final ECSSVersion m_eVersion;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eVersion) {
        this.m_eVersion = (ECSSVersion)((Object)ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version"));
    }

    private void _expectNodeType(@Nonnull CSSNode aNode, @Nonnull ECSSNodeType eExpected) {
        if (!eExpected.isNode(aNode, this.m_eVersion)) {
            throw new CSSHandlingException(aNode, "Expected a '" + eExpected.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + "'");
        }
    }

    private static void _throwUnexpectedChildrenCount(@Nonnull CSSNode aNode, @Nonnull @Nonempty String sMsg) {
        s_aLogger.error(sMsg);
        int i = 0;
        while (i < aNode.jjtGetNumChildren()) {
            s_aLogger.error("  " + aNode.jjtGetChild(i));
            ++i;
        }
        throw new CSSHandlingException(aNode, sMsg);
    }

    @Nonnull
    private CSSImportRule _createImportRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.IMPORTRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected at last 2 children but got " + nChildCount + "!");
        }
        CSSURI aImportURI = null;
        int nCurrentIndex = 0;
        if (nChildCount > 0) {
            CSSNode aURINode = aNode.jjtGetChild(0);
            if (ECSSNodeType.URL.isNode(aURINode, this.m_eVersion)) {
                aImportURI = new CSSURI(aURINode.getText());
                aImportURI.setSourceLocation(aURINode.getSourceLocation());
                ++nCurrentIndex;
            } else if (!ECSSNodeType.MEDIALIST.isNode(aURINode, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName(aURINode, this.m_eVersion));
            }
        }
        if (aImportURI == null) {
            aImportURI = new CSSURI(ParseUtils.extractStringValue(aNode.getText()));
        }
        CSSImportRule ret = new CSSImportRule(aImportURI);
        ret.setSourceLocation(aNode.getSourceLocation());
        if (nChildCount > nCurrentIndex) {
            CSSNode aMediaListNode = aNode.jjtGetChild(nCurrentIndex);
            if (ECSSNodeType.MEDIALIST.isNode(aMediaListNode, this.m_eVersion)) {
                for (CSSNode aMediaQueryNode : aMediaListNode) {
                    ret.addMediaQuery(this._createMediaQuery(aMediaQueryNode));
                }
                ++nCurrentIndex;
            } else {
                s_aLogger.error("Expected an MEDIALIST node but got " + ECSSNodeType.getNodeName(aMediaListNode, this.m_eVersion));
            }
        }
        if (nCurrentIndex < nChildCount) {
            s_aLogger.error("Import statement has children which are unhandled.");
        }
        return ret;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode aNode) {
        CSSSelectorAttribute ret;
        this._expectNodeType(aNode, ECSSNodeType.ATTRIB);
        int nChildren = aNode.jjtGetNumChildren();
        String sNamespacePrefix = null;
        int nOperatorIndex = 0;
        if (nChildren > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(aNode.jjtGetChild(0), this.m_eVersion)) {
            sNamespacePrefix = aNode.jjtGetChild(0).getText();
            nOperatorIndex = 1;
        }
        String sAttrName = aNode.getText();
        if (nChildren == nOperatorIndex) {
            ret = new CSSSelectorAttribute(sNamespacePrefix, sAttrName);
        } else {
            int nExpectedChildCount = nOperatorIndex + 2;
            if (nChildren != nExpectedChildCount) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Illegal number of children present (" + nChildren + ") - expected " + nExpectedChildCount);
            }
            CSSNode aOperator = aNode.jjtGetChild(nOperatorIndex);
            this._expectNodeType(aOperator, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode aAttrValue = aNode.jjtGetChild(nOperatorIndex + 1);
            this._expectNodeType(aAttrValue, ECSSNodeType.ATTRIBVALUE);
            ret = new CSSSelectorAttribute(sNamespacePrefix, sAttrName, ECSSAttributeOperator.getFromNameOrNull(aOperator.getText()), aAttrValue.getText());
        }
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode aNode) {
        int nChildCount = aNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(aNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(aNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(aNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(aNode, this.m_eVersion)) {
            if (nChildCount != 0) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "CSS simple selector member expected 0 children and got " + nChildCount);
            }
            CSSSelectorSimpleMember ret = new CSSSelectorSimpleMember(aNode.getText());
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        if (ECSSNodeType.ATTRIB.isNode(aNode, this.m_eVersion)) {
            return this._createSelectorAttribute(aNode);
        }
        if (ECSSNodeType.SELECTORCOMBINATOR.isNode(aNode, this.m_eVersion)) {
            String sText = aNode.getText();
            ECSSSelectorCombinator eCombinator = ECSSSelectorCombinator.getFromNameOrNull(sText);
            if (eCombinator == null) {
                s_aLogger.error("Failed to parse CSS selector combinator '" + sText + "'");
            }
            return eCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(aNode, this.m_eVersion)) {
            ArrayList<CSSSelector> aNestedSelectors = new ArrayList<CSSSelector>();
            int i = 0;
            while (i < nChildCount) {
                CSSNode aChildNode = aNode.jjtGetChild(0);
                CSSSelector aSelector = this._createSelector(aChildNode);
                aNestedSelectors.add(aSelector);
                ++i;
            }
            CSSSelectorMemberNot ret = new CSSSelectorMemberNot(aNestedSelectors);
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        if (ECSSNodeType.PSEUDO.isNode(aNode, this.m_eVersion)) {
            if (nChildCount == 0) {
                CSSSelectorSimpleMember ret = new CSSSelectorSimpleMember(aNode.getText());
                ret.setSourceLocation(aNode.getSourceLocation());
                return ret;
            }
            if (nChildCount == 1) {
                CSSNode aChildNode = aNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(aChildNode, this.m_eVersion)) {
                    CSSSelectorSimpleMember ret = new CSSSelectorSimpleMember(String.valueOf(aNode.getText()) + aChildNode.getText() + ")");
                    ret.setSourceLocation(aNode.getSourceLocation());
                    return ret;
                }
                CSSExpression aExpr = this._createExpression(aChildNode);
                CSSSelectorMemberFunctionLike ret = new CSSSelectorMemberFunctionLike(aNode.getText(), aExpr);
                ret.setSourceLocation(aNode.getSourceLocation());
                return ret;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + nChildCount + " args: " + aNode.toString());
        }
        s_aLogger.error("Unsupported selector child: " + ECSSNodeType.getNodeName(aNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.SELECTOR);
        CSSSelector ret = new CSSSelector();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            ICSSSelectorMember aMember = this._createSelectorMember(aChildNode);
            if (aMember == null) continue;
            ret.addMember(aMember);
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionMathProduct(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MATHPRODUCT);
        CSSExpressionMemberMathProduct ret = new CSSExpressionMemberMathProduct();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.MATHUNIT.isNode(aChildNode, this.m_eVersion)) {
                int nChildCount = aChildNode.jjtGetNumChildren();
                if (nChildCount == 0) {
                    CSSExpressionMemberMathUnitSimple aMember = new CSSExpressionMemberMathUnitSimple(aChildNode.getText());
                    aMember.setSourceLocation(aChildNode.getSourceLocation());
                    ret.addMember(aMember);
                    continue;
                }
                if (nChildCount != 1) {
                    CSSNodeToDomainObject._throwUnexpectedChildrenCount(aChildNode, "CSS math unit expected 1 child and got " + nChildCount);
                }
                CSSNode aChildChildNode = aChildNode.jjtGetChild(0);
                CSSExpressionMemberMathProduct aNestedProduct = this._createExpressionMathProduct(aChildChildNode);
                CSSExpressionMemberMathUnitProduct aMember = new CSSExpressionMemberMathUnitProduct(aNestedProduct);
                ret.addMember(aMember);
                continue;
            }
            if (ECSSNodeType.MATHPRODUCTOPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                if (eMathOp == null) {
                    s_aLogger.error("Failed to parse math product operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eMathOp);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberTermURI _createExpressionURL(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.URL);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 0) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected 0 children but got " + nChildCount + "!");
        }
        CSSURI aURI = new CSSURI(aNode.getText());
        aURI.setSourceLocation(aNode.getSourceLocation());
        return new CSSExpressionMemberTermURI(aURI);
    }

    @Nonnull
    private CSSExpressionMemberFunction _createExpressionFunction(@Nonnull CSSNode aNode) {
        CSSExpressionMemberFunction aFunc;
        this._expectNodeType(aNode, ECSSNodeType.FUNCTION);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 1) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected 0 or 1 children but got " + nChildCount + "!");
        }
        String sFunctionName = aNode.getText();
        if (nChildCount == 1) {
            CSSNode aFirstChild = aNode.jjtGetChild(0);
            CSSExpression aFuncExpr = this._createExpression(aFirstChild);
            aFunc = new CSSExpressionMemberFunction(sFunctionName, aFuncExpr);
        } else {
            aFunc = new CSSExpressionMemberFunction(sFunctionName);
        }
        aFunc.setSourceLocation(aNode.getSourceLocation());
        return aFunc;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionMathTerm(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MATH);
        CSSExpressionMemberMath ret = new CSSExpressionMemberMath();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.MATHPRODUCT.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(this._createExpressionMathProduct(aChildNode));
                continue;
            }
            if (ECSSNodeType.MATHSUMOPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                if (eMathOp == null) {
                    s_aLogger.error("Failed to parse math operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eMathOp);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.EXPRTERM);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 1) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected 0 or 1 children but got " + nChildCount + "!");
        }
        if (nChildCount == 0) {
            CSSExpressionMemberTermSimple ret = new CSSExpressionMemberTermSimple(aNode.getText());
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        CSSNode aChildNode = aNode.jjtGetChild(0);
        if (ECSSNodeType.URL.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionURL(aChildNode);
        }
        if (ECSSNodeType.FUNCTION.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionFunction(aChildNode);
        }
        if (ECSSNodeType.MATH.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionMathTerm(aChildNode);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.EXPR);
        CSSExpression ret = new CSSExpression();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.EXPRTERM.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(this._createExpressionTerm(aChildNode));
                continue;
            }
            if (ECSSNodeType.EXPROPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSExpressionOperator eOp = ECSSExpressionOperator.getFromNameOrNull(sText);
                if (eOp == null) {
                    s_aLogger.error("Failed to parse expression operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eOp);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nullable
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLEDECLARATION);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount < 1 && nChildCount > 1) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected 1-3 children but got " + nChildCount + "!");
        }
        if (nChildCount == 1) {
            return null;
        }
        if (!ECSSNodeType.EXPR.isNode(aNode.jjtGetChild(1), this.m_eVersion)) {
            return null;
        }
        String sProperty = aNode.jjtGetChild(0).getText();
        CSSExpression aExpression = this._createExpression(aNode.jjtGetChild(1));
        boolean bImportant = false;
        if (nChildCount == 3) {
            CSSNode aChildNode = aNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode(aChildNode, this.m_eVersion)) {
                bImportant = true;
            } else {
                s_aLogger.error("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            }
        }
        CSSDeclaration ret = new CSSDeclaration(sProperty, aExpression, bImportant);
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nonnull
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLERULE);
        CSSStyleRule ret = new CSSStyleRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        boolean bSelectors = true;
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.SELECTOR.isNode(aChildNode, this.m_eVersion)) {
                if (!bSelectors) {
                    s_aLogger.error("Found a selector after a declaration!");
                }
                ret.addSelector(this._createSelector(aChildNode));
                continue;
            }
            bSelectors = false;
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                int nDecl = 0;
                while (nDecl < nDecls) {
                    CSSDeclaration aDeclaration;
                    CSSNode aChildChildNode = aChildNode.jjtGetChild(nDecl);
                    if (!ECSSNodeType.isErrorNode(aChildChildNode, this.m_eVersion) && (aDeclaration = this._createDeclaration(aChildChildNode)) != null) {
                        ret.addDeclaration(aDeclaration);
                    }
                    ++nDecl;
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode aNode) {
        CSSNode aFirstChild;
        this._expectNodeType(aNode, ECSSNodeType.PAGERULE);
        int nChildCount = aNode.jjtGetNumChildren();
        String sPseudoPage = null;
        int nStartIndex = 0;
        if (nChildCount > 0 && ECSSNodeType.PSEUDOPAGE.isNode(aFirstChild = aNode.jjtGetChild(0), this.m_eVersion)) {
            sPseudoPage = aFirstChild.getText();
            ++nStartIndex;
        }
        CSSPageRule ret = new CSSPageRule(sPseudoPage);
        ret.setSourceLocation(aNode.getSourceLocation());
        int nIndex = nStartIndex;
        while (nIndex < nChildCount) {
            CSSNode aChildNode = aNode.jjtGetChild(nIndex);
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                int nDecl = 0;
                while (nDecl < nDecls) {
                    CSSDeclaration aDeclaration = this._createDeclaration(aChildNode.jjtGetChild(nDecl));
                    if (aDeclaration != null) {
                        ret.addDeclaration(aDeclaration);
                    }
                    ++nDecl;
                }
            } else if (!ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) {
                s_aLogger.error("Unsupported page rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            }
            ++nIndex;
        }
        return ret;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule ret = new CSSMediaRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.MEDIALIST.isNode(aChildNode, this.m_eVersion)) {
                for (CSSNode aMediaListChildNode : aChildNode) {
                    ret.addMediaQuery(this._createMediaQuery(aMediaListChildNode));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createStyleRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createViewportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createSupportsRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported media-rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode aNode) {
        CSSNode aNextChild;
        CSSNode aFirstChildNode;
        if (ECSSNodeType.MEDIUM.isNode(aNode, this.m_eVersion)) {
            String sMedium = aNode.getText();
            if (ECSSMedium.getFromNameOrNull(sMedium) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + sMedium + "'");
            }
            CSSMediaQuery ret = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, sMedium);
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        this._expectNodeType(aNode, ECSSNodeType.MEDIAQUERY);
        int nChildCount = aNode.jjtGetNumChildren();
        int nStartIndex = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (nChildCount > 0 && ECSSNodeType.MEDIAMODIFIER.isNode(aFirstChildNode = aNode.jjtGetChild(0), this.m_eVersion)) {
            String sMediaModifier = aFirstChildNode.getText();
            if (sMediaModifier != null) {
                if ("not".equalsIgnoreCase(sMediaModifier)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase(sMediaModifier)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    s_aLogger.error("Unsupported media modifier '" + sMediaModifier + "' found!");
                }
            }
            ++nStartIndex;
        }
        String sMedium = null;
        if (nChildCount > nStartIndex && ECSSNodeType.MEDIUM.isNode(aNextChild = aNode.jjtGetChild(nStartIndex), this.m_eVersion)) {
            sMedium = aNextChild.getText();
            if (ECSSMedium.getFromNameOrNull(sMedium) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + sMedium + "'");
            }
            ++nStartIndex;
        }
        CSSMediaQuery ret = new CSSMediaQuery(eModifier, sMedium);
        ret.setSourceLocation(aNode.getSourceLocation());
        int i = nStartIndex;
        while (i < nChildCount) {
            CSSNode aChildNode = aNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(aChildNode, this.m_eVersion)) {
                ret.addMediaExpression(this._createMediaExpr(aChildNode));
            } else if (!ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) {
                s_aLogger.error("Unsupported media query child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            }
            ++i;
        }
        return ret;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode aNode) {
        CSSMediaExpression ret;
        CSSNode aFeatureNode;
        this._expectNodeType(aNode, ECSSNodeType.MEDIAEXPR);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 1 && nChildCount != 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected 1 or 2 children but got " + nChildCount + "!");
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(aFeatureNode = aNode.jjtGetChild(0), this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(aFeatureNode, this.m_eVersion));
        }
        String sFeature = aFeatureNode.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(sFeature) == null) {
            s_aLogger.warn("Media expression uses unknown feature '" + sFeature + "'");
        }
        if (nChildCount == 1) {
            ret = new CSSMediaExpression(sFeature);
        } else {
            CSSNode aValueNode = aNode.jjtGetChild(1);
            ret = new CSSMediaExpression(sFeature, this._createExpression(aValueNode));
        }
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.FONTFACERULE);
        CSSFontFaceRule ret = new CSSFontFaceRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                int nDecl = 0;
                while (nDecl < nDecls) {
                    CSSDeclaration aDeclaration = this._createDeclaration(aChildNode.jjtGetChild(nDecl));
                    if (aDeclaration != null) {
                        ret.addDeclaration(aDeclaration);
                    }
                    ++nDecl;
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.KEYFRAMESRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount == 0) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected at least 1 child but got " + nChildCount + "!");
        }
        String sKeyframesDeclaration = aNode.getText();
        CSSNode aAnimationNameNode = aNode.jjtGetChild(0);
        this._expectNodeType(aAnimationNameNode, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String sAnimationName = aAnimationNameNode.getText();
        CSSKeyframesRule ret = new CSSKeyframesRule(sKeyframesDeclaration, sAnimationName);
        ret.setSourceLocation(aNode.getSourceLocation());
        int nIndex = 1;
        CSSKeyframesBlock aBlock = null;
        while (nIndex < nChildCount) {
            CSSNode aChildNode = aNode.jjtGetChild(nIndex);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(aChildNode, this.m_eVersion)) {
                ArrayList<String> aKeyframesSelectors = new ArrayList<String>();
                for (CSSNode aSelectorChild : aChildNode) {
                    this._expectNodeType(aSelectorChild, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    aKeyframesSelectors.add(aSelectorChild.getText());
                }
                aBlock = new CSSKeyframesBlock(aKeyframesSelectors);
                aBlock.setSourceLocation(aChildNode.getSourceLocation());
                ret.addBlock(aBlock);
            } else if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                if (aBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                int nDecls = aChildNode.jjtGetNumChildren();
                int nDecl = 0;
                while (nDecl < nDecls) {
                    CSSDeclaration aDeclaration = this._createDeclaration(aChildNode.jjtGetChild(nDecl));
                    if (aDeclaration != null) {
                        aBlock.addDeclaration(aDeclaration);
                    }
                    ++nDecl;
                }
            } else if (!ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) {
                s_aLogger.error("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            }
            ++nIndex;
        }
        return ret;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.VIEWPORTRULE);
        String sViewportDeclaration = aNode.getText();
        CSSViewportRule ret = new CSSViewportRule(sViewportDeclaration);
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                int nDecl = 0;
                while (nDecl < nDecls) {
                    CSSDeclaration aDeclaration = this._createDeclaration(aChildNode.jjtGetChild(nDecl));
                    if (aDeclaration != null) {
                        ret.addDeclaration(aDeclaration);
                    }
                    ++nDecl;
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.NAMESPACERULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount < 1 || nChildCount > 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected at least 1 child and at last 2 children but got " + nChildCount + "!");
        }
        String sPrefix = null;
        int nURLIndex = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(aNode.jjtGetChild(0), this.m_eVersion)) {
            sPrefix = aNode.jjtGetChild(0).getText();
            ++nURLIndex;
        }
        CSSNode aURLNode = aNode.jjtGetChild(nURLIndex);
        this._expectNodeType(aURLNode, ECSSNodeType.NAMESPACERULEURL);
        String sURL = ParseUtils.extractStringValue(aURLNode.getText());
        CSSNamespaceRule ret = new CSSNamespaceRule(sPrefix, sURL);
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nullable
    private ICSSSupportsConditionMember _createSupportsConditionMemberRecursive(@Nonnull CSSNode aNode) {
        int nChildCount = aNode.jjtGetNumChildren();
        if (ECSSNodeType.SUPPORTSCONDITIONOPERATOR.isNode(aNode, this.m_eVersion)) {
            if (nChildCount != 0) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected no children but got " + nChildCount + "!");
            }
            return ECSSSupportsConditionOperator.getFromNameCaseInsensitiveOrNull(aNode.getText());
        }
        if (ECSSNodeType.SUPPORTSNEGATION.isNode(aNode, this.m_eVersion)) {
            ICSSSupportsConditionMember aNestedMember;
            if (nChildCount != 1) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected at exactly 1 child but got " + nChildCount + "!");
            }
            if ((aNestedMember = this._createSupportsConditionMemberRecursive(aNode.jjtGetChild(0))) == null) {
                return null;
            }
            CSSSupportsConditionNegation ret = new CSSSupportsConditionNegation(aNestedMember);
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        if (ECSSNodeType.SUPPORTSCONDITIONINPARENS.isNode(aNode, this.m_eVersion)) {
            CSSNode aChildNode;
            if (nChildCount != 1) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected at exactly 1 child but got " + nChildCount + "!");
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(aChildNode = aNode.jjtGetChild(0), this.m_eVersion)) {
                CSSDeclaration aDeclaration = this._createDeclaration(aChildNode);
                if (aDeclaration == null) {
                    throw new CSSHandlingException(aChildNode, "The style declaration in the @supports rule is invalid!");
                }
                CSSSupportsConditionDeclaration ret = new CSSSupportsConditionDeclaration(aDeclaration);
                ret.setSourceLocation(aNode.getSourceLocation());
                return ret;
            }
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(aChildNode, this.m_eVersion)) {
                CSSSupportsConditionNested ret = new CSSSupportsConditionNested();
                for (CSSNode aChildChildNode : aChildNode) {
                    ICSSSupportsConditionMember aMember = this._createSupportsConditionMemberRecursive(aChildChildNode);
                    if (aMember == null) continue;
                    ret.addMember(aMember);
                }
                return ret;
            }
            s_aLogger.error("Unsupported supportsConditionInParents child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            return null;
        }
        if (!ECSSNodeType.isErrorNode(aNode, this.m_eVersion)) {
            s_aLogger.error("Unsupported supports-condition child: " + ECSSNodeType.getNodeName(aNode, this.m_eVersion));
        }
        return null;
    }

    @Nonnull
    private CSSSupportsRule _createSupportsRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.SUPPORTSRULE);
        CSSSupportsRule ret = new CSSSupportsRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(aChildNode, this.m_eVersion)) {
                for (CSSNode aChildChildNode : aChildNode) {
                    ICSSSupportsConditionMember aMember = this._createSupportsConditionMemberRecursive(aChildChildNode);
                    if (aMember == null) continue;
                    ret.addSupportConditionMember(aMember);
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createStyleRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createViewportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createSupportsRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported supports-rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSUnknownRule _createUnknownRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.UNKNOWNRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(aNode, "Expected 2 children but got " + nChildCount + "!");
        }
        CSSNode aParameterList = aNode.jjtGetChild(0);
        this._expectNodeType(aParameterList, ECSSNodeType.UNKNOWNRULEPARAMETERLIST);
        CSSNode aBody = aNode.jjtGetChild(1);
        this._expectNodeType(aBody, ECSSNodeType.UNKNOWNRULEBODY);
        String sRuleDeclaration = aNode.getText();
        CSSUnknownRule ret = new CSSUnknownRule(sRuleDeclaration);
        ret.setSourceLocation(aNode.getSourceLocation());
        ret.setParameterList(aParameterList.getText());
        ret.setBody(aBody.getText());
        return ret;
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.ROOT);
        CascadingStyleSheet ret = new CascadingStyleSheet();
        ret.setSourceLocation(aNode.getSourceLocation());
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.CHARSET.isNode(aChildNode, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addImportRule(this._createImportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addNamespaceRule(this._createNamespaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createStyleRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createViewportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createSupportsRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createUnknownRule(aChildNode));
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLEDECLARATIONLIST);
        CSSDeclarationList ret = new CSSDeclarationList();
        ret.setSourceLocation(aNode.getSourceLocation());
        int nDecls = aNode.jjtGetNumChildren();
        int nDecl = 0;
        while (nDecl < nDecls) {
            CSSDeclaration aDeclaration = this._createDeclaration(aNode.jjtGetChild(nDecl));
            if (aDeclaration != null) {
                ret.addDeclaration(aDeclaration);
            }
            ++nDecl;
        }
        return ret;
    }
}

