/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.commons.ValueEnforcer;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.handler.CSSHandlingException;
import com.phloc.css.handler.CSSNodeToDomainObject;
import com.phloc.css.handler.ECSSNodeType;
import com.phloc.css.parser.CSSNode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSHandler {
    private static final CSSHandler s_aInstance = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eVersion, @Nonnull CSSNode aNode) {
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        ValueEnforcer.notNull((Object)aNode, (String)"Node");
        if (!ECSSNodeType.ROOT.isNode(aNode, eVersion)) {
            throw new CSSHandlingException(aNode, "Passed node is not a root node!");
        }
        return new CSSNodeToDomainObject(eVersion).createCascadingStyleSheetFromNode(aNode);
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eVersion, @Nonnull CSSNode aNode) {
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        ValueEnforcer.notNull((Object)aNode, (String)"Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(aNode, eVersion)) {
            throw new CSSHandlingException(aNode, "Passed node is not a style declaration node!");
        }
        return new CSSNodeToDomainObject(eVersion).createDeclarationListFromNode(aNode);
    }
}

