/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.visit;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.NonBlockingStack;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSSupportsRule;
import com.phloc.css.decl.CSSUnknownRule;
import com.phloc.css.decl.CSSViewportRule;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.visit.ICSSUrlVisitor;
import com.phloc.css.decl.visit.ICSSVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor aVisitor) {
        this.m_aVisitor = (ICSSUrlVisitor)ValueEnforcer.notNull((Object)aVisitor, (String)"Visitor");
    }

    @Nonnull
    public ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule aImportRule) {
        this.m_aVisitor.onImport(aImportRule);
    }

    @Override
    public void onNamespace(@Nonnull CSSNamespaceRule aNamespaceRule) {
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        ICSSTopLevelRule aTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : (ICSSTopLevelRule)this.m_aTopLevelRule.peek();
        CSSExpression aExpr = aDeclaration.getExpression();
        for (ICSSExpressionMember aMember : aExpr.getAllMembers()) {
            if (!(aMember instanceof CSSExpressionMemberTermURI)) continue;
            CSSExpressionMemberTermURI aExprTerm = (CSSExpressionMemberTermURI)aMember;
            this.m_aVisitor.onUrlDeclaration(aTopLevelRule, aDeclaration, aExprTerm);
        }
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule aStyleRule) {
        this.m_aTopLevelRule.push((Object)aStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@Nonnull CSSSelector aSelector) {
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule aStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule aPageRule) {
        this.m_aTopLevelRule.push((Object)aPageRule);
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule aPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule) {
        this.m_aTopLevelRule.push((Object)aFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule aMediaRule) {
        this.m_aTopLevelRule.push((Object)aMediaRule);
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule aMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule) {
        this.m_aTopLevelRule.push((Object)aKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@Nonnull CSSViewportRule aViewportRule) {
        this.m_aTopLevelRule.push((Object)aViewportRule);
    }

    @Override
    public void onEndViewportRule(@Nonnull CSSViewportRule aViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@Nonnull CSSSupportsRule aSupportsRule) {
        this.m_aTopLevelRule.push((Object)aSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@Nonnull CSSSupportsRule aSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@Nonnull CSSUnknownRule aUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

