/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.shorthand;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.css.ECSSUnit;
import com.phloc.css.decl.shorthand.CSSPropertyWithDefaultValue;
import com.phloc.css.decl.shorthand.CSSShortHandDescriptor;
import com.phloc.css.decl.shorthand.CSSShortHandDescriptorMarginPadding;
import com.phloc.css.property.CCSSProperties;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.utils.ECSSColor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CSSShortHandRegistry {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final Map<ECSSProperty, CSSShortHandDescriptor> s_aMap = new HashMap<ECSSProperty, CSSShortHandDescriptor>();

    static {
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BACKGROUND, new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_COLOR, "transparent"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_IMAGE, "none"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_REPEAT, "repeat"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_POSITION, "top left"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_ATTACHMENT, "scroll"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_CLIP, "border-box"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_ORIGIN, "padding-box"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_SIZE, "auto auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.FONT, new CSSPropertyWithDefaultValue(CCSSProperties.FONT_STYLE, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_VARIANT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_WEIGHT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_SIZE, "inherit"), new CSSPropertyWithDefaultValue(CCSSProperties.LINE_HEIGHT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_FAMILY, "inherit")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_TOP, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_RIGHT, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_BOTTOM, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_LEFT, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_WIDTH, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_WIDTH, ECSSUnit.px(3))));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_STYLE, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_STYLE, "solid")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_COLOR, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorMarginPadding(ECSSProperty.MARGIN, new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_TOP, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_RIGHT, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_BOTTOM, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_LEFT, "auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorMarginPadding(ECSSProperty.PADDING, new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_TOP, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_RIGHT, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_BOTTOM, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_LEFT, "auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.OUTLINE, new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.LIST_STYLE, new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_TYPE, "disc"), new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_POSITION, "outside"), new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_IMAGE, "none")));
    }

    private CSSShortHandRegistry() {
    }

    public static void registerShortHandDescriptor(@Nonnull CSSShortHandDescriptor aDescriptor) {
        ValueEnforcer.notNull((Object)aDescriptor, (String)"Descriptor");
        ECSSProperty eProperty = aDescriptor.getProperty();
        s_aRWLock.writeLock().lock();
        try {
            if (s_aMap.containsKey(eProperty)) {
                throw new IllegalStateException("A short hand for property '" + eProperty.getName() + "' is already registered!");
            }
            s_aMap.put(eProperty, aDescriptor);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<ECSSProperty> getAllShortHandProperties() {
        s_aRWLock.readLock().lock();
        try {
            Set set = ContainerHelper.newSet(s_aMap.keySet());
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static boolean isShortHandProperty(@Nullable ECSSProperty eProperty) {
        if (eProperty == null) {
            return false;
        }
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aMap.containsKey(eProperty);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    public static CSSShortHandDescriptor getShortHandDescriptor(@Nullable ECSSProperty eProperty) {
        if (eProperty == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            CSSShortHandDescriptor cSSShortHandDescriptor = s_aMap.get(eProperty);
            return cSSShortHandDescriptor;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }
}

